/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

/**
 * A class that holds additional metadata than a SimpleMetaData
 * 
 * @see BatchBackingStore
 */
public final class BatchMetadata extends SimpleMetadata {

    private String appId;

    private String id;

    /**
     * Construct a Metadata object
     * 
     * @param version
     *            The version of the data. A freshly created state has a version ==
     *            0
     * @param lastAccessTime
     *            the last access time of the state. This must be used in
     *            conjunction with getMaxInactiveInterval to determine if the
     *            state is idle enough to be removed.
     * @param maxInactiveInterval
     *            the maximum time that this state can be idle in the store
     *            before it can be removed.
     * @param data
     *            The data
     * @param extraData
     *            Some more data
     */
    public BatchMetadata(String appId, String id, long version,
            long lastAccessTime, long maxInactiveInterval, byte[] data,
            String extraData) {
        super(version, lastAccessTime, maxInactiveInterval, data, extraData);
        this.appId = appId;
        this.id = id;
    }

    /**
     * Return the application id
     * 
     * @return the application id
     * @see BackingStoreFactory
     */
    public String getAppId() {
        return appId;
    }

    /**
     * Return the id of the metaData
     * 
     * @return the id of the metaData
     */
    public String getId() {
        return id;
    }

}
