/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.ha.spi;

import java.util.Collection;

/**
 * A class to hold a collection of children AttributeMetadata. This class is
 * used mainly to store a collection of AttributeMetaData that are part of a
 * WebSession. The metadata about the web session itself can be obtained
 * directly from the CompositeMetadata itself, while the metadata of its
 * attributes can be obtained from the individual AttributeMetadata that is part
 * of the collection returned by getEntries().
 */
public final class CompositeMetadata extends Metadata {
    
    private byte[] state;

    private Collection<AttributeMetadata> entries;
    
    private String extraParam;    

    /**
     * Construct a CompositeMetadata object
     * 
     * @param version
     *            The version of the data. A freshly created state has a version ==
     *            0
     * @param lastAccesstime
     *            the last access time of the state. This must be used in
     *            conjunction with getMaxInactiveInterval to determine if the
     *            state is idle enough to be removed.
     * @param maxInactiveInterval
     *            the maximum time that this state can be idle in the store
     *            before it can be removed.
     * @param state
     *            The (trunk) state
     * @param extraParam
     *            Some more data
     * @param entries
     *            the AttributeMetadata that are part of this Metadata
     */
    public CompositeMetadata(long version, long lastAccessTime,
            long maxInactiveInterval, Collection<AttributeMetadata> entries, byte[] state, String extraParam) {
        super(version, lastAccessTime, maxInactiveInterval);
        this.entries = entries;
        this.state = state;
        this.extraParam = extraParam;
    }   

    /**
     * Returns a collection of Metadata (or its subclass). Note that though it
     * is possible to have a compositeMetadata itself as part of this
     * collection, typically they contain only AttributeMetaData
     * 
     * @return a collection of AttributeMetadata
     */
    public Collection<AttributeMetadata> getEntries() {
        return entries;
    }
    
    /**
     * Get the state of the object that is stored.
     * 
     * @return the state or null
     */
    public byte[] getState() {
        return state;
    }    
    
    /**
     * Get the extra param associated with this metadata
     * 
     * @return the extra param or null
     */
    public String getExtraParam() {
        return extraParam;
    }     

}
