/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth.callback;

import java.security.KeyStore;
import javax.security.auth.callback.Callback;

/**
 * Callback for trusted certificate KeyStore.
 *
 * <p> A trusted certificate KeyStore may be used to determine
 * whether a given certificate chain can be trusted.
 *
 * @version %I%, %G%
 */
public class TrustStoreCallback
        extends javax.security.auth.message.callback.TrustStoreCallback {

    /**
     * Set the trusted certificate KeyStore.
     *
     * @param trustStore the trusted certificate KeyStore,
     *		which must already be loaded.
     */
    public void setStore(KeyStore trustStore) {
	setTrustStore(trustStore);
    }
}
