/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;

import java.util.ListResourceBundle;

/**
 * INTERNAL:
 * English ResourceBundle for OptimisticLockException messages.
 *
 * Creation date: (12/6/00 9:47:38 AM)
 * @author: Xi Chen
 */
public class OptimisticLockExceptionResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "5001", "An attempt was made to delete the object [{0}], but it has no version number in the identity map. {3}It may not have been read before the delete was attempted. {3}Class> {1} Primary Key> {2}" },
                                           { "5003", "The object [{0}] cannot be deleted because it has changed or been deleted since it was last read. {3}Class> {1} Primary Key> {2}" },
                                           { "5004", "An attempt was made to update the object [{0}], but it has no version number in the identity map. {3}It may not have been read before the update was attempted. {3}Class> {1} Primary Key> {2}" },
                                           { "5006", "The object [{0}] cannot be updated because it has changed or been deleted since it was last read. {3}Class> {1} Primary Key> {2}" },
                                           { "5007", "The object [{0}] must have a non-read-only mapping to the version lock field." },
                                           { "5008", "Must map the version lock field to java.sql.Timestamp when using Timestamp Locking" },
                                           { "5009", "The object of class [{1}] of class [{0}] cannot be unwrapped because it was deleted since it was last read." },
                                           { "5010", "The object [{0}] cannot be merged because it has changed or been deleted since it was last read. {3}Class> {1}" }
                                           
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
