/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.sessions;

import java.util.*;
import java.sql.*;
import java.io.*;

/**
 * <b>Purpose</b>:
 * Define an interface for supplying TopLink with a <code>Connection</code> to
 * a JDBC database.
 * <p>
 * <b>Description</b>:
 * This interface defines the methods to be implemented that allow TopLink to
 * acquire a <code>Connection</code> to a JDBC database. There are only 2
 * methods that need to be implemented:
 * <blockquote><code>
 * java.sql.Connection connect(java.util.Properties properties)<br>
 * void toString(java.io.PrintWriter writer)
 * </code></blockquote>
 * Once these methods have been implemented, an instance of the new
 * <code>Connector</code> can be  passed
 * to a <code>JDBCLogin</code> at startup. For example:
 * <blockquote><code>
 * session.getLogin().setConnector(new FooConnector());<br>
 * session.login();
 * </code></blockquote>
 *
 * @see DatabaseLogin
 * @author Big Country
 * @since TOPLink/Java 2.1
 */
public interface Connector extends Serializable, Cloneable {

    /**
     * PUBLIC:
     * Must be cloneable.
     */
    Object clone();

    /**
     * PUBLIC:
     * Connect with the specified properties and return the <code>Connection</code>.
     * The properties are driver-specific; but usually contain the <code>"user"</code>
     * and <code>"password"</code>. Additional
     * properties can be built by using <code>JDBCLogin.setProperty(String propertyName,
     * Object propertyValue)</code>.
     * @return java.sql.Connection
     */
    Connection connect(Properties properties);

    /**
     * PUBLIC:
     * Print something useful on the log. This information will be displayed
     * on the TopLink log (by default <code>System.out</code>) at login.
     * See the other implementations of this method for examples.
     */
    void toString(PrintWriter writer);

    /**
     * PUBLIC:
     * Provide the details of my connection information. This is primarily for JMX runtime services.
     * @return java.lang.String
     */
    String getConnectionDetails();
}
