package com.sun.gjc.spi;

import com.sun.logging.LogDomains;
import com.sun.gjc.common.DataSourceObjectBuilder;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.sql.Connection;
import java.io.Serializable;


/**
 * Factory to create JDBC objects
 */
public abstract class JdbcObjectsFactory implements Serializable {

    private static Logger _logger;

    static {
        _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    }

    /**
     * Returns JDBC Objet Factory for JDBC 3.0 or JDBC 4.0 depending upon the jdbc version<br>
     * available in JDK.<br>
     * @return JdbcObjectsFactory
     */
    public static JdbcObjectsFactory getInstance() {
        boolean jdbc40 = DataSourceObjectBuilder.isJDBC40();
        JdbcObjectsFactory factory = null;
        try {
            if (jdbc40) {
                factory = (JdbcObjectsFactory) Class.forName("com.sun.gjc.spi.jdbc40.Jdbc40ObjectsFactory").newInstance();
            } else {
                factory = (JdbcObjectsFactory) Class.forName("com.sun.gjc.spi.jdbc30.Jdbc30ObjectsFactory").newInstance();
            }
        } catch (Exception e) {
            _logger.log(Level.WARNING, "jdbc.jdbc_factory_class_load_exception", e);
        }
        return factory;
    }

    /**
     * Returns a DataSource instance.
     * @param mcfObject Managed Connection Factory
     * @param cmObject  Connection Manager
     * @return DataSource
     */
    public abstract javax.sql.DataSource getDataSourceInstance(com.sun.gjc.spi.ManagedConnectionFactory mcfObject,
                                                               javax.resource.spi.ConnectionManager cmObject);
    /**
     * To get an instance of ConnectionHolder.<br>
     * Will return a ConnectionHolder with or without wrapper<br>
     *
     * @param conObject Connection
     * @param mcObject  ManagedConnection
     * @param criObject Connection Request Info
     * @param statementWrapping Whether to wrap statement objects or not.
     * @return ConnectionHolder
     */
    public abstract com.sun.gjc.spi.base.ConnectionHolder getConnection(Connection conObject,
                                                                        com.sun.gjc.spi.ManagedConnection mcObject,
                                                                        javax.resource.spi.ConnectionRequestInfo criObject,
                                                                        boolean statementWrapping);


}
