/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message;

import java.util.Map;

/**
 * The AuthStatus class is used to represent return values from Authentication
 * modules and Authentication Contexts. An AuthStatus value is returned when 
 * the module processing has established a corresponding request or response 
 * message within the message parameters exchanged with the runtime.
 *
 * @version %I%, %G%
 * @see Map
 */

public class AuthStatus {

    /**
     * Indicates that the message processing by the authentication module 
     * was successful and that the runtime is to proceed with its normal 
     * processing of the resulting message.
     */
    public static final AuthStatus SUCCESS = new AuthStatus(1);
    
    /**
     * Indicates that the message processing by the authentication module 
     * was NOT successful, and that the module replaced the application
     * message with an error message.
     */
    public static final AuthStatus FAILURE = new AuthStatus(2);

    /**
     * Indicates that the message processing by the authentication module 
     * was successful and that the runtime is to proceed by sending 
     * a message returned by the authentication module.
     */
    public static final AuthStatus SEND_SUCCESS = new AuthStatus(3);
    
    /**
     * Indicates that the message processing by the authentication module 
     * was NOT successful, that the module replaced the application
     * message with an error message, and that the runtime is to proceed
     * by sending the error message.
     */
    public static final AuthStatus SEND_FAILURE = new AuthStatus(4);

    /**
     * Indicates the message processing by the authentication module 
     * is NOT complete, that the module replaced the application
     * message with a security message, and that the runtime is to proceed
     * by sending the security message.
     */
    public static final AuthStatus SEND_CONTINUE = new AuthStatus(5);

    private int v;

    private AuthStatus() {
	v = 1;
    }

    private AuthStatus(int value) {
	v = value;
    }

}


