/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message;

import java.util.Map;

/**
 * A message processing runtime uses this interface to pass messages and
 * message processing state to authentication contexts for processing by 
 * authentication modules.
 * <p>
 * This interface encapsulates a request message object and 
 * a response message object for a message exchange.
 * This interface may also be used to associate additional context
 * in the form of key/value pairs, with the encapsulated messages.
 * <p>
 * Every implementation of this interface should provide a zero argument
 * constructor, and a constructor which takes a single Map argument.
 * Additional constructors may also be provided.
 * <p>
 *
 * @version %I%, %G%
 * @see Map
 */

public interface MessageInfo { 

    /**
     * Get the request message object from this MessageInfo.
     *
     * @return an object representing the request message,
     * or null if no request message is set within the MessageInfo.
     */

    public Object getRequestMessage();

    /**
     * Get the response message object from this MessageInfo.
     *
     * @return an object representing the response message,
     * or null if no response message is set within the MessageInfo.
     */

    public Object getResponseMessage();

    /**
     * Set the request message object in this MessageInfo.
     * @param request an object representing the request message.
     */

    public void setRequestMessage(Object request);

    /**
     * Set the response message object in this MessageInfo.
     * @param response an object representing the response message.
     * .
     */
    public void setResponseMessage(Object response);

    /**
     * Get (a reference to) the Map object of this MessageInfo. 
     * Operations performed on the acquired Map must effect the 
     * Map within the MessageInfo.
     * 
     * @return the Map object of this MessageInfo.
     * This method never returns null. If a Map has not 
     * been associated with the MessageInfo, this method 
     * instantiates a Map, associates it with this MessageInfo,
     * and then returns it.
     */
    public Map getMap();

}



