/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.callback;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;

/**
 * Callback for setting the container's caller (or Remote user) principal
 * This callback is intended to be called by a <code>serverAuthModule</code> 
 * during its <code>validateRequest</code> processing. 
 *
 * @version %I%, %G%
 */
public class CallerPrincipalCallback implements Callback {

    private Subject subject;
    private Principal principal;
    private String name;

 /**
     * Create a CallerPrincipalCallback to set the container's 
     * representation of the caller principal
     *
     * @param s the Subject in which the container will distinguish the
     * caller identity.
     *
     * @param p the Principal that will be distinguished as the caller
     * principal. This value may be null.
     * <p> 
     * The CallbackHandler must establish the argument Principal as the caller
     * principal associated with the invocation being processed by the
     * container. When the argument Principal is null, the handler will establish
     * the container's representation of the unauthenticated caller
     * principal.
     */
    public CallerPrincipalCallback(Subject s, Principal p) { 
	subject = s;
	principal = p;
        name = null;
    }

    /**
     * Create a CallerPrincipalCallback to set the container's 
     * representation of the caller principal.
     *
     * @param s the Subject in which the container will distinguish the
     * caller identity.
     *
     * @param n the String value that will be returned when getName() is
     * called on the principal established as the caller principal or null.
     * <p> 
     * When the n argument is null, the handler will establish
     * the container's representation of the unauthenticated caller
     * principal (which may or may not be equal to null, depending on
     * the requirements of the container type). When the container 
     * type requires that a non-null principal be established as the 
     * caller principal, the value obatined by calling getName on the
     * principal may not match the arument value.
     */
    public CallerPrincipalCallback(Subject s, String n) { 
	subject = s;
	principal = null;
        name = n;
    }

    /**
     * Get the Subject in which the handler will distinguish the caller 
     * principal
     *
     * @return the subject.
     */
    public Subject getSubject() {
	return subject;
    }

    /**
     * Get the caller principal.
     *
     * @return the principal or null.
     * <p> 
     * when the values returned by this method and the getName methods 
     * are null, the handler must establish the container's representation 
     * of the unauthenticated caller principal within the Subject.
     */
    public Principal getPrincipal() {
	return principal;
    }

    /**
     * Get the caller principal name.
     *
     * @return the principal name or null.
     * <p> 
     * when the values returned by this method and the getPrincipal methods 
     * are null, the handler must establish the container's representation 
     * of the unauthenticated caller principal within the Subject.
     */
    public String getName() {
	return name;
    }
}
