/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.callback;

import java.security.KeyStore;
import java.security.cert.CertStore;
import javax.security.auth.callback.Callback;

/**
 * Callback for CertStore.
 *
 * <p> A CertStore is a generic repository for certificates.
 * CertStores may be searched to locate public key certificates,
 * as well as to put together certificate chains.
 * Such a search may be necessary when the caller needs to
 * verify a signature.
 *
 * @version %I%, %G%
 */
public class CertStoreCallback implements Callback {

    private CertStore certStore;

    /**
     * Create a CertStoreCallback.
     */
    public CertStoreCallback() { }

    /**
     * Used by the CallbackHandler to set the CertStore within the Callback.
     *
     * @param certStore the certificate store, which may be null
     */
    public void setCertStore(CertStore certStore) {
	this.certStore = certStore;
    }

    /**
     * Used by the CertStore user to obtain the CertStore set within the  
     * Callback.
     *
     * @return the CertStore, or null.
     */
    public CertStore getCertStore() {
	return certStore;
    }
}
