/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.callback;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;

/**
 * Callback establishing group principals within the argument subject.
 * This callback is intended to be called by a <code>serverAuthModule</code> 
 * during its <code>validateRequest</code> processing. 
 *
 * @version %I%, %G%
 */
public class GroupPrincipalCallback implements Callback {

    private Subject subject;
    private String[] groups;

    /**
     * Create a GroupPrincipalCallback to establish the container's 
     * representation of the corresponding group principals within
     * the Subject.
     *
     * @param s the Subject in which the container will create
     * group principals.
     *
     * @param g an array of Strings, where each element contains
     * the name of a group that will be used to create a 
     * corresponding group principal within the Subject.
     * <p> 
     * When a null value is passed to the g argument, the handler will 
     * establish the container's representation of no group principals within
     * the Subject. 
     * Otherwise, the handler's processing of this callback is
     * additive, yielding the union (without duplicates) of the principals 
     * existing within the Subject, and those created with the names occuring 
     * within the argument array. The CallbackHandler will define the type 
     * of the created principals. 
     */
    public GroupPrincipalCallback(Subject s, String[] g) {
	subject = s;
	groups = g;
    }

    /**
     * Get the Subject in which the handler will establish the 
     * group principals.
     *
     * @return the subject.
     */
    public Subject getSubject() {
	return subject;
    }

    /**
     * Get the array of group names. 
     *
     * @return null, or an array containing 0 or more String group names. 
     * <p>
     * When the return value is null, the handler will 
     * establish the container's representation of no group principals within
     * the Subject. 
     *
     * Otherwise, the handler's processing of this callback is
     * additive, yielding the union (without duplicates) of the principals 
     * created with the names in the returned array and those existing 
     * within the Subject.
     */
    public String[] getGroups() {
	return groups;
    }

}
