/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.config;

import java.util.Map;

import javax.security.auth.message.*;

/**
 * This interface defines the common functionality implemented by
 * Authentication context configuration objects.
 *
 * @version %I%, %G%
 * @see ClientAuthContext
 * @see ServerAuthContext
 */
public interface AuthConfig {
    /**
     * Get the message layer name of this authentication context configuration 
     * object.
     *
     * @return the message layer name of this configuration object, or null if 
     * the configuration object pertains to an unspecified message layer.
     */
    String getMessageLayer();


    /**
     * Get the application context identifier of this authentication 
     * context configuration object.
     *
     * @return the String identifying the application context of this
     * configuration object or null if the configuration object pertains
     * to an unspecified application context.
     */
    String getAppContext();

    /**
     * Get the authentication context identifier corresponding to the
     * request and response objects encapsulated in messageInfo.
     *
     * @param messageInfo a contextual Object that encapsulates the
     *          client request and server response objects.
     *
     * @return the authentication context identifier corresponding to the 
     *          encapsulated request and response objects, or null.
     *
     * @throws IllegalArgumentException if the type of the message
     * objects incorporated in messageInfo are not compatible with
     * the message types supported by this 
     * authentication context configuration object.
     */

    public String getAuthContextID(MessageInfo messageInfo);

    /**
     * Causes a dynamic anthentication context configuration object to 
     * update the internal state that it uses to process calls to its
     * <code>getAuthContext</code> method.
     *
     * @exception AuthException if an error occured during the update.
     *
     * @exception SecurityException if the caller does not have permission
     *		to refresh the configuration object.
     */
    public void refresh();

    /**
     * Used to determine whether the authentication context configuration 
     * object encapsulates any protected authentication contexts.
     *
     * @return true if the configuration object encapsulates at least one
     *        protected authentication context. Otherwise, this method 
     *        returns false.
     */
    public boolean isProtected();
}

