/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.config;

import java.util.Map;
import javax.security.auth.Subject;

import javax.security.auth.message.*;

/**
 * This interface describes a configuration of ServerAuthConfiguration objects
 * for a message layer and application context (e.g., the messaging context of 
 * a specific application, or set of applications). 
 *
 * <p> Implementations of this interface are returned by an AnthConfigProvider.
 *
 * <p> Callers interact with a ServerAuthConfig to obtain ServerAuthContext
 * objects suitable for processing a given message exchange at the layer and
 * within the application context of the ServerAuthConfig
 *
 * Each ServerAuthContext object is responsible for instantiating, 
 * initializing, and invoking the one or more ServerAuthModules 
 * encapsulated in the ServerAuthContext.
 *
 * <p> After having acquired a ServerAuthContext, a caller operates on the
 * context to cause it to invoke the encapsulated ServerAuthModules to
 * validate service requests and to secure service responses.
 *
 * @version %I%, %G%
 * @see AuthConfigProvider
 */
public interface ServerAuthConfig extends AuthConfig {

    /**
     * Get a ServerAuthContext instance from this ServerAuthConfig.
     *
     * <p> The implementation of this method returns a ServerAuthContext
     * instance that encapsulates the ServerAuthModules used to
     * validate requests and secure responses associated
     * with the given <i>authContextID</i>.
     *
     * <p> Specifically, this method accesses this ServerAuthConfig
     * object with the argument <i>authContextID</i> to determine the
     * ServerAuthModules that are to be encapsulated in the returned
     * ServerAuthContext instance.
     * 
     * <P> The ServerAuthConfig object establishes the request 
     * and response MessagePolicy objects that are passed to the encapsulated 
     * modules when they are initialized by the returned ServerAuthContext 
     * instance. It is the modules' responsibility to enforce these policies 
     * when invoked.
     * 
     * @param authContextID an identifier used to index
     *		the provided <i>config</i>, or null.
     *		This value must be identical to the value returned by
     *		the <code>getAuthContextID</code> method for all
     *		<code>MessageInfo</code> objects passed to the
     *		<code>validateRequest</code>
     *		method of the returned ServerAuthContext.
     *
     * @param serviceSubject a Subject that represents the source of the 
     *          service response to be secured by the acquired authentication
     *          context. The principal and/or credentials of
     *          the Subject may be used to select or acquire the 
     *          authentication context. If the Subject is not null, 
     *          additional Principals or credentials (pertaining to the source 
     *          of the response) may be added to the Subject. A null value may
     *          be passed for this parameter.
     *
     * @param properties a Map object that may be used by
     *          the caller to augment the properties that will be passed 
     *          to the encapsulated modules at module initialization.
     *          The null value may be passed for this parameter.
     *
     * @return a ServerAuthContext instance that encapsulates the
     *		ServerAuthModules used to secure and validate
     *		requests/responses associated with the given 
     *          <i>authContextID</i>,
     *		or null (indicating that no modules are configured).
     *
     * @exception AuthException if this method fails.
     */
    public abstract ServerAuthContext 
    getAuthContext(String authContextID, Subject serviceSubject, Map properties) 
	throws AuthException;


}

