/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.security.auth.message.module;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

import javax.security.auth.message.*;

// just for @see tag
import javax.security.auth.message.config.ClientAuthContext;

/**
 * A ClientAuthModule secures request messages, and validates received
 * response messages.
 *
 * <p> A module implementation should assume it may be used to secure
 * different requests as different clients. A module should also assume
 * it may be used concurrently by multiple callers.  It is the module
 * implementation's responsibility to properly save and restore any state
 * as necessary.  A module that does not need to do so
 * may remain completely stateless.
 *
 * <p> Every implementation of the interface must provide a public zero 
 * argument contructor.
 *
 * @version %I%, %G%
 *
 * @see ClientAuthContext
 */
public interface ClientAuthModule extends ClientAuth {

    /**
     * Initialize this module with request and response message policies
     * to enforce, a CallbackHandler, and any module-specific configuration
     * properties.
     *
     * <p> The request policy and the response policy must not both be null.
     *
     * @param requestPolicy the request policy this module must enforce,
     *		or null.
     *
     * @param responsePolicy the response policy this module must enforce,
     *		or null.
     *
     * @param handler CallbackHandler used to request information.
     *
     * @param options a Map of module-specific configuration properties.
     *
     * @exception AuthException if module initialization fails, including for
     * the case where the options argument contains elements that are not 
     * supported by the module.
     */

    void initialize(MessagePolicy requestPolicy,
	       MessagePolicy responsePolicy,
	       CallbackHandler handler,
	       Map options)
	throws AuthException;

    /**
     * Get the one or more Class objects representing the message types 
     * supported by the module.
     *
     * @return an array of Class objects where each element 
     * defines a message type supported by the module. 
     * A module should return an array containing at
     * least one element. An empty array indicates that the module
     * will attempt to support any message type. This method
     * never returns null. 
     */
    public Class[] getSupportedMessageTypes();

}


