/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jmac.config;

import java.io.IOException;
import java.util.Map;
import java.util.Set;

import com.sun.enterprise.config.ConfigContext;

/**
 * AuthConfigImpl relies on a ConfigParser to read
 * the module configuration.
 *
 * <p> The ConfigParser is expected to parse that information
 * into the HashMap described below.
 *
 * @version %I%, %G%
 */
interface ConfigParser {
    /**
     * Initialize the parser with given ConfigContext.
     * Passing null as argument means the system will find a ConfigContext
     * as possible.
     * @param configContext
     */
    void initialize(ConfigContext configContext) throws IOException;

    /**
     * Get the module configuration information.
     * The information is returned as a HashMap.
     *
     * <p> The key is an intercept:
     * <ul>
     * <li>SOAP
     * <li>HttpServlet
     * </ul>
     *
     * <p>The value is a AuthConfigImpl.InterceptEntry, which contains:
     * <ul>
     * <li> default provider ID
     * <li> default type (client or server)
     * <li> HashMap, where
     *		key	= provider ID
     *		value	= BaseAuthConfigImpl.IDEntry
     * </ul>
     *
     * <p> An IDEntry contains:
     * <ul>
     * <li> type (client or server)
     * <li> moduleClassName
     * <li> default requestPolicy
     * <li> default responsePolicy
     * <li> options
     * <li> 
     * </ul>
     */
    Map getConfigMap();

    /**
     * Get the name of layers with default set in domain.xml.
     */
    Set<String> getLayersWithDefault();
}
