#
# The contents of this file are subject to the terms 
# of the Common Development and Distribution License 
# (the License).  You may not use this file except in
# compliance with the License.
# 
# You can obtain a copy of the license at 
# https://glassfish.dev.java.net/public/CDDLv1.0.html or
# glassfish/bootstrap/legal/CDDLv1.0.txt.
# See the License for the specific language governing 
# permissions and limitations under the License.
# 
# When distributing Covered Code, include this CDDL 
# Header Notice in each file and include the License file 
# at glassfish/bootstrap/legal/CDDLv1.0.txt.  
# If applicable, add the following below the CDDL Header, 
# with the fields enclosed by brackets [] replaced by
# you own identifying information: 
# "Portions Copyrighted [year] [name of copyright owner]"
# 
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
#

#
# NOTE: This file is used by Enterprise, Messaging AND Collabra servers.
#       Please do NOT change indiscriminately
#

include $(BUILD_ROOT)/make/defines_UNIX.mk
LOCAL_COPY=0

# xlC_r will compile both C and C++ code
#
# Do NOT add compiler options to any of these lines
# These macros define the compiler, not compiler options/flags/etc.
#
CC		= $(PRE_CC) /usr/bin/xlC_r
CPPCMD	=/usr/ccs/lib/cpp -P
C 		= $(PRE_CC) /usr/bin/xlC_r
C++C		= $(PRE_CC) /usr/bin/xlC_r
LD		= $(PRE_LD) /usr/bin/ld
AR		= /usr/bin/ar cr $@
# fix linkage problems on NFS
#RANLIB		= /usr/bin/ranlib
RANLIB		= sleep 10; /bin/ranlib
FTP		= /usr/bin/ftp
#STRIP		= /bin/strip
# on AIX strip is broken
STRIP		= /bin/touch

# what is NLIST?
NLIST		 = xcoff

# Verity defines
VERITY_ARCH =_rs6k41

ifdef DEBUG_BUILD
CC_DEBUG	= -g -qfullpath -qsrcmsg # -qsrcmsg outputs source on error
C_DEBUG         = -g -qfullpath -qsrcmsg # -qfullpath for debug dbx path
LD_DEBUG	=
else
# optimized flags here
CC_DEBUG	= -O2
C_DEBUG         = -O2
LD_DEBUG	= -s
endif

PRELIB		= -brtl

ifndef JAVA_VERSION
JAVA_VERSION    = 2
endif

JNI_MD_LIBTYPE  = classic
JNI_MD_LIBDIR   = bin

JAVA            = $(EXTERNAL_JDK_DIR)/jre/sh/java
JAVAC           = $(EXTERNAL_JDK_DIR)/sh/javac
JAVAH           = $(EXTERNAL_JDK_DIR)/sh/javah
JAR             = $(EXTERNAL_JDK_DIR)/sh/jar
JAVADOC         = $(EXTERNAL_JDK_DIR)/sh/javadoc

# Shared library build
DLL_PRESUF        = 
ES_RPATH          = .:../lib:../../lib
DEF_LIBPATH       = /usr/lib/threads:/usr/ibmcxx/lib:/usr/lib:/lib
LD_RPATH          = $(DEF_LIBPATH):$(ES_RPATH)
LD_DYNAMIC        = -p 0 -berok -blibpath:$(LD_RPATH)
MKSHLIB           = /usr/ibmcxx/bin/makeC++SharedLib_r $(LD_DYNAMIC)
PLATFORM_CC_OPTS += -qansithrow

PLATFORM_DEF	= -DSVR4 -DSYSV -DAIX -DAIXV4 -D_AIX42 -DAIX4_3 -D_REENTRANT -DCOMPAT_43
RPATH_PREFIX = -blibpath:

################
#### Xerces ####
################
XERCES_DEFS += -qnotempinc -D_THREAD_SAFE

# xlC_r already calls libpthreads, libC_r and libc_r in the correct order
# (see /etc/xlC.cfg) - 98/06/23 jsalter
#
# Add PRE_PLATFORM_LIB on AIX to support defining libpthreads before libc_r
# when necessary - 98/06 jsalter (this could probably be useful on other
# platforms as well)
#
PLATFORM_LIB	 += $(PRE_PLATFORM_LIB) dl

LD_LIB_VAR        = LIBPATH

#BUILD_ORACLE=1
#BUILD_SYBASE=1
#BUILD_INFORMIX=1
#BUILD_ODBC=1

# No support for mapfiles
USE_MAPFILE=

