/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PropertyUtils.java
 *
 * Created on March 18, 2001, 12:30 PM
 */

package com.sun.enterprise.tools.common;

import java.lang.reflect.Method;
import java.beans.PropertyDescriptor;

import com.sun.enterprise.tools.common.util.diagnostics.Reporter;
import com.sun.enterprise.tools.common.util.diagnostics.StackTrace;

/**
 *
 * @author  vkraemer
 * @version 
 */
public class PropertyUtils {

    /** Creates new PropertyUtils */
    private PropertyUtils() {
    }

    public static Method getWriter(Object target, String destFieldName) throws java.beans.IntrospectionException {
        try {
            PropertyDescriptor destPd = new PropertyDescriptor(destFieldName, target.getClass());
            return destPd.getWriteMethod();
        }
        catch (java.beans.IntrospectionException t) {
            Reporter.critical(new StackTrace(t)); //NOI18N
            throw t;
        }
    }
    
        public static Method getReader(Object target, String destFieldName) throws java.beans.IntrospectionException {
        try {
            PropertyDescriptor destPd = new PropertyDescriptor(destFieldName, target.getClass());
            return destPd.getReadMethod();
        }
        catch (java.beans.IntrospectionException t) {
            //Reporter.critical(new StackTrace(t)); //NOI18N
            //throw t;
            return getReader2(target,destFieldName);
        }
    }

        public static Method getReader2(Object target, String destFieldName) throws java.beans.IntrospectionException {
            String getterName = createGetterName(destFieldName);
            Class targetClass = null;
        try {
            targetClass = target.getClass();
            Method reader = targetClass.getMethod(getterName,null);
            return reader;
            //PropertyDescriptor destPd = new PropertyDescriptor(destFieldName, target.getClass());
            //return destPd.getReadMethod();
        }
        catch (Throwable t) {
            Method[] allmethods = targetClass.getMethods();
            for (int i = 0; null != allmethods && i < allmethods.length; i++)
                Reporter.info(allmethods[i].getReturnType() + " " +allmethods[i].getName());//NOI18N
            Reporter.critical(new StackTrace(t)); //NOI18N
            throw new java.beans.IntrospectionException(getterName);
            //return getReader2(target,destFieldName);
        }
        }
        
        static private String createGetterName(String propName) {
            String retVal = "get";//NOI18N
            String capitalizedProp = propName.toUpperCase();
            return retVal + capitalizedProp.substring(0,1) + propName.substring(1);
        }
    }

