/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PropertyElements.java
 *
 * Created on March 13, 2002, 2:00 PM
 */

package com.sun.enterprise.tools.common.properties;

import com.sun.enterprise.tools.common.dd.connector.ResourceAdapter;
import com.sun.enterprise.tools.common.dd.connector.SunConnector;
import java.io.FileInputStream;
/**
 *
 * @author  vkraemer
 * @version 
 */
public class PropertyElements {

    private ResourceAdapter ra;

    /** Creates new PropertyElements */
    public PropertyElements(ResourceAdapter ra) {
        this.ra = ra;
    }
    
    public PropertyElements(PropertyElements source) {
        this.ra = (ResourceAdapter) source.ra.clone();
    }
    
    public ResourceAdapter getResourceAdapter() {
        return ra;
    }
    
    public Object getAttributeDetail(int row, int col) { 
        return ra.getAttributeValue(ResourceAdapter.PROPERTY, row, intToAttribute(col)); //NOI18N
    }
    
    public void setAttributeDetail(Object v, int r, int c) { 
        String input = (String) v;
        if (null == input || 0 == input.trim().length()) {
            // test for need to delete
            if (r >= getLength())
                return;
            int otherDex = c - 1;
            if (otherDex < 0)
                otherDex = -otherDex;
            String otherVal = ra.getAttributeValue(ResourceAdapter.PROPERTY, r, 
                intToAttribute(otherDex));
            if (null == otherVal || 0 == otherVal.trim().length()) {
                ra.removePropertyElement(r);
                return;
            }
            input = " "; // NOI18N
        }
        while (r >= getLength())
            ra.addPropertyElement(true);
        ra.setAttributeValue(ResourceAdapter.PROPERTY, r, intToAttribute(c), input); //NOI18N
    }

    public int getLength() {
        return ra.sizePropertyElement();
    }
    
    public int getWidth() {
        return 2;
    }
    
    private String intToAttribute(int col) {
        if (col == 0) 
            return "name"; // NOI18N
        if (col == 1)
            return "value"; // NOI18N
        return "error"; // NOI18N
    }

    // this is used for debugging the PropertyElementsTableModel DO NOT EXPOSE
    //
    PropertyElements(String args[]) {
        int rowCount = 0;
        if (null != args && args.length > 0) {
            try {
                rowCount = Integer.parseInt(args[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ra = new ResourceAdapter();
        for (int i = 0; i < rowCount; i++) {
            ra.addPropertyElement(true);
            ra.setAttributeValue(ResourceAdapter.PROPERTY,i,"name",""+i); //NOI18N
            ra.setAttributeValue(ResourceAdapter.PROPERTY,i,"value",""+(rowCount - i)); //NOI18N
        }
        //
        // Note: the ResourceAdapter MUST be part of a SunConnector or the
        // PropertyElementsTableModel is BROKEN.
        SunConnector connectorDD = SunConnector.createGraph();
        connectorDD.setResourceAdapter(ra);
    }
    
    //ResourceAdapter getRA() {
        //return ra;
    //}
    
    String dumpIt() {
        return ra.dumpBeanNode();
    }

    public String toString() {
        return ra.dumpBeanNode();
    }
}
