/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

// PENDING copied from ejbmodule data object

package com.sun.enterprise.tools.common.util;

import org.netbeans.modules.jarpackager.api.ArchiveEntry;
import com.sun.forte4j.j2ee.lib.dd.ejb2.gen.EjbJar;
import com.sun.forte4j.j2ee.lib.dataobject.J2eeDataObject;

public class ExtractUtils {
    
    /**
     * convert an icon urls into an icon references.
     *
     * @param url    a string representing the url of an icon.
     * @return The name of the ArchiveEntry in a form appropriate for
     *         putting in a deployment descriptor.
     */
    static String urlToReference(String url) {
        if ((url == null)        ||
            (url.equals("null")) ||             // NOI18N
            (url.length() == 0)    ) {
            return null;
        }
        // Make an ArchiveEntry.
        // This is a little bit inefficient as we throw this away
        // and it will be made again later.
        ArchiveEntry archiveEntry = J2eeDataObject.urlToArchiveEntry(url);
        return archiveEntry.getName();
    }

    /**
     * Copy the UserInfo .
     * Also convert icon urls into icon references.
     *
     * @param from   copy from here
     * @param to     copy to here
     */
    static public void copyUserInfo(EjbJar from, EjbJar to) {
        String url;
        String reference;

        url = from.getLargeIcon();
        reference = urlToReference(url);
        to.setLargeIcon(reference);

        url = from.getSmallIcon();
        reference = urlToReference(url);
        to.setSmallIcon(reference);
        
//        System.out.println("Copying " + from.getDescription()); //NOI18N

        to.setDescription(from.getDescription());
        to.setDisplayName(from.getDisplayName());
    }
}
