/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common;

import java.io.*;
import java.util.*;
import java.util.logging.*;
import com.sun.enterprise.tools.upgrade.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.certconversion.ProcessAdaptor;
import com.sun.enterprise.tools.upgrade.cluster.*;

/**
 *
 * author : Gautam Borah
 *
 */

public class CommonInfoModel{
    public static final String DOMAINS = "domains";
    public static final String CONFIG = "config";
    private static final String CERT_FILE_NAME = "keystore.jks";
    private static final String TRUSTED_KEY_STORE = "cacerts.jks";
    private static final String LICENSE_FILE = "LICENSE.txt";
    private static final String NUMBERSTRING = "0123456789";
    
    private StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.common");
    /**
     * Information specific to the certificate transformation module
     **/
    private static Logger logger=LogService.getLogger(LogService.UPGRADE_LOGGER);
    private String[] CERT_ALIASES;
    private String SOURCE_INSTALL_DIR;
    private boolean sourceInputAsDomainRoot;
    private boolean enlistDomain;
    private String TARGET_INSTALL_DIR;
    private String InstallConfig70;
    private boolean certificateConversionFlag=false;
    private List domainList;
    private List domainOptionList;
    private String targetDomainRoot;
    private String sourceDomainRoot="";
    private String currentDomain;
    private String currentSourceServerInstance = "";
    private String osName;
    
    // This is filled in only for EE
    private String currentCluster;
    
    // domainMapping stores domain name as key and domain path (..../domains/domain1) as value
    private Hashtable domainMapping;
    private Map domainNSSPwdMapping;
    private Map domainTargetNSSPwdMapping;
    private Map domainJKSPwdMapping;
    private Map domainJKSCAPwdMapping;
    private Map domainssPwdFileMapping;
    private Map domainTargetnssPwdFileMapping;
    private Map domainNameMapping;
    private String sourceVersionEdition;
    private String targetVersionEdition;
    private boolean isInPlace = false;
    private String targetVersion;
    private String targetDefaultProfile;

    // These are needed to create instances.
    private String adminUserName = null;
    private String adminPassword = null;
    private File passwordFile = null;
    private String passwordFilePath = null;
    private String masterPassword = "changeit";
   
    //Default values to be used in the tmp file created during upgrade
    private String AS_ADMIN_USER = "admin";
    private String AS_ADMIN_ADMINPASSWORD = "adminadmin";
    private String AS_ADMIN_MASTERPASSWORD = "changeit";

    //Added - CR 6426419
    private String sourceApplicationRoot;

    //Admin credential changes. Added for CR 6454007
    private Map domainCredentials;
    private List passwordFileList;
 
    
    public CommonInfoModel(){
        domainList = new ArrayList();
        domainOptionList = new ArrayList();
        domainNSSPwdMapping = new HashMap();
        domainTargetNSSPwdMapping = new HashMap();
        domainJKSPwdMapping = new HashMap();
        domainJKSCAPwdMapping = new HashMap();
        domainssPwdFileMapping= new HashMap();
        domainTargetnssPwdFileMapping= new HashMap();
        domainNameMapping= new HashMap();
        //Admin credential changes. Added for CR 6454007
        domainCredentials = new HashMap();
        passwordFileList = new ArrayList();
    }
    
	// This is solely used for solaris 10 upgrade .... need to clean up
    public void setTargetDomainRoot(String targetDomainsRoot) {
        if(targetDomainRoot != null && targetDomainRoot.equals(targetDomainsRoot))
            return;
        this.targetDomainRoot=targetDomainsRoot;
        try {
            String logPath = targetDomainRoot+File.separator+"upgrade.log";
            logger.info(stringManager.getString("common.log.redirect") + logPath);
            LogService.initialize(logPath);
        } catch(Exception e) {
            logger.warning(e.getLocalizedMessage());
        }
    }
    
    // This is solely used for solaris 10 upgrade .... need to clean up
    public String getTargetDomainRoot() {
        return targetDomainRoot;
    }
    
    // This is solely used for solaris 10 upgrade .... need to clean up
    public void setSourceDomainRoot(String sourceDomainRoot) {
        this.sourceDomainRoot=sourceDomainRoot;
    }
    
    // This is solely used for solaris 10 upgrade .... need to clean up
    public String getSourceDomainRoot() {
        return sourceDomainRoot;
    }
    public String getSourceDomainPath(){
        //String path = SOURCE_INSTALL_DIR + File.separator + DOMAINS + File.separator + currentDomain;
        return ((DomainInfo)getDomainMapping().get(currentDomain)).getDomainPath();
    }
    
    public String getSourceInstancePath(){
        //return getSourceDomainPath() + File.separator + getCurrentSourceInstance();
        return ((DomainInfo)this.getDomainMapping().get(this.getCurrentDomain())).getInstancePath(this.getCurrentSourceInstance());
    }
    
    public String getCurrentSourceInstance() {
        return currentSourceServerInstance;
    }
    
    public void setCurrentSourceInstance(String server) {
        currentSourceServerInstance = server;
    }
    
    public String getTargetConfig() {
        String config = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(currentDomain) + File.separator + CONFIG;
        return config;
    }
    
    public String getTargetJKSKeyStorePath(){
        String path = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(currentDomain) + File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }
    
    public String getTargetTrustedJKSKeyStorePath(){
        String path = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(currentDomain) + File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }
    
    public String getSourceJKSKeyStorePath(){
        String path = getSourceDomainPath() +  File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }
    
    public String getSourceTrustedJKSKeyStorePath(){
        String path = getSourceDomainPath() +  File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }
    
    public String getDestinationDomainPath(){
        return getDestinationDomainPath(this.currentDomain);
    }
    public String getDestinationDomainPath(String domainName){
        String path = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(domainName);
        return path;
    }
    
    public void addDomainName(String domainName){
        domainList.add(domainName);
    }
    
    public List getDomainList(){
        return domainList;
    }
    
    public void addDomainOptionName(String domainName){
        domainOptionList.add(domainName);
    }
    
    public List getDomainOptionList(){
        return domainOptionList;
    }
    
    public String getCurrentDomain(){
        return currentDomain;
    }
    public void setCurrentDomain(String domainName){
        currentDomain=domainName;
    }
    
    public boolean getCertificateConversionFlag() {
        return certificateConversionFlag;
    }
    
    public void setCertificateConversionFlag(boolean flag){
        certificateConversionFlag=flag;
    }
    
    public String getSourceInstallDir() {
        return SOURCE_INSTALL_DIR;
    }
    
    public String getTargetInstallDir() {
        return System.getProperty("com.sun.aas.installRoot");
        //return TARGET_INSTALL_DIR;
    }
    
    public void setSourceInstallDir(String src) {
        SOURCE_INSTALL_DIR = src;
    }
    
    public void setTargetInstallDir(String tgt) {
        TARGET_INSTALL_DIR = tgt;
    }
    
    /**
     * Get the password for the NSS certificate database. If this is an NSS to NSS or NSS to JKS migration, the
     * String returned will be the source server password and getTargetCertDbPassword() will return
     * the target db password. If JKS to NSS, returns the target certificate db password.
     * @return String certpassword - the certificate password for the current domain and instance or null if the current
     *                               instance does not have a password, and should not be included in the cert migration.
     */
    public String getCertDbPassword() {
        Map instanceNSSPwdMap = (Map)domainNSSPwdMapping.get(currentDomain);
        return (String)instanceNSSPwdMap.get(currentSourceServerInstance);
    }
    
    public void setCertDbPassword(String pwd) {
        setCertDbPassword(currentDomain, currentSourceServerInstance, pwd);
    }
    
    public void setCertDbPassword(String domain, String pwd) {
        setCertDbPassword(domain, currentSourceServerInstance, pwd);
    }
    
    public void setCertDbPassword(String domain, String instance, String pwd) {
        Map instanceNssPwdMap = (Map)domainNSSPwdMapping.get(domain);
        if(instanceNssPwdMap == null) {
            instanceNssPwdMap = new HashMap();
        }
        instanceNssPwdMap.put(instance, pwd);
        domainNSSPwdMapping.put(domain,instanceNssPwdMap);
    }
    
    public String getTargetCertDbPassword() {
        return (String)domainTargetNSSPwdMapping.get(currentDomain);
    }
    
    public void setTargetCertDbPassword(String pwd) {
        domainTargetNSSPwdMapping.put(currentDomain,pwd);
        //NSS_DB_PASSWORD=pwd;
    }
    public void setTargetCertDbPassword(String domain, String pwd) {
        domainTargetNSSPwdMapping.put(domain,pwd);
    }
    
    public String[] getCertAliases() {
        return CERT_ALIASES;
    }
    
    public String getJksKeystorePassword() {
        return (String)domainJKSPwdMapping.get((String)domainNameMapping.get(currentDomain));
    }
    
    public void setJksKeystorePassword(String pwd) {
        domainJKSPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
        //JKS_DB_PASSWORD=pwd;
    }
    public void setJksKeystorePassword(String domain, String pwd) {
        domainJKSPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
    }
    
    public String getJksCAKeystorePassword() {
        return (String)domainJKSCAPwdMapping.get((String)domainNameMapping.get(currentDomain));
    }
    
    public void setJksCAKeystorePassword(String pwd) {
        domainJKSCAPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
    }
    
    public void setJksCAKeystorePassword(String domain, String pwd) {
        domainJKSCAPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
    }
    
    public Hashtable getDomainMapping() {
        return domainMapping;
    }
    
    public void setDomainMapping(Hashtable domainMapping) {
        this.domainMapping = domainMapping;
    }
    
    public String getOSName() {
        return osName;
    }
    
    public void setOSName(String osName){
        this.osName = osName;
    }
    
    public String getNSSPwdFile() {
        return (String)domainssPwdFileMapping.get(currentDomain);
    }
    
    public void setNSSPwdFile(String pwdFile){
        domainTargetnssPwdFileMapping.put(currentDomain,pwdFile);
    }
    
    public String getTargetNSSPwdFile() {
        return (String)domainTargetnssPwdFileMapping.get(currentDomain);
    }
    
    public void setTargetNSSPwdFile(String pwdFile){
        domainTargetnssPwdFileMapping.put(currentDomain,pwdFile);
    }
    
    public void setInstallConfig70(String config) {
        InstallConfig70 = config;
    }
    
    public String getInstallConfig70() {
        return InstallConfig70;
    }
    public Map getTargetDomainNameMapping(){
        return domainNameMapping;
    }
    
    public boolean isInPlace() {
        return isInPlace;
    }
    
    public void setIsInPlace(boolean isInPlace) {
        this.isInPlace = isInPlace;
    }
    /**
     * @return a logger to use in the Module implementation classes
     */
    public static Logger getDefaultLogger() {
        if (logger==null) {
            logger = LogService.getLogger(LogService.UPGRADE_LOGGER);
        }
        return logger;
    }
    
    public boolean isUpgradeJKStoJKS() {
        //Case : 8.xPE/9.0PE -> developer profile	    
        String sourceVersionAndEdition = getSourceVersionAndEdition();			
        if (UpgradeConstants.VERSION_AS80_PE.equals(sourceVersionAndEdition) ||
                UpgradeConstants.VERSION_AS81_PE.equals(sourceVersionAndEdition)) {
            return true;
        }
        return false;
    }
    
    public boolean isUpgradeJKStoNSS() {
        //Case : 8.xPE/9.0PE -> enterprise profile - Domain always created with developer profile.	    
        return false;
        /*if (UpgradeConstants.EDITION_EE.equals(getTargetEdition()) ||
                UpgradeConstants.EDITION_SE.equals(getTargetEdition())) {
            String sourceVersionAndEdition = getSourceVersionAndEdition();			
            if (UpgradeConstants.VERSION_AS80_PE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS81_PE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS90_PE.equals(sourceVersionAndEdition)) {
                return true;
            }
        }
        return false;*/
    }
    
    public boolean isUpgradeNSStoNSS() {
        //Case : 8.1EE->9.1 : domain created as enterprise in target. 7.x not supported for now.
        String sourceVersionAndEdition = getSourceVersionAndEdition();
        if(UpgradeConstants.VERSION_AS81_EE.equals(sourceVersionAndEdition)) {
            return true;
        }
        /*if (UpgradeConstants.EDITION_EE.equals(getTargetEdition()) ||
                UpgradeConstants.EDITION_SE.equals(getTargetEdition())) {
            String sourceVersionAndEdition = getSourceVersionAndEdition();			
            if (UpgradeConstants.VERSION_AS7X_PE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS7X_SE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS7X_EE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS81_EE.equals(sourceVersionAndEdition)) {
                return true;
            }
        }*/
        return false;
    }
    
    public boolean isUpgradeNSStoJKS() {
        //Case : 8.1EE -> 9.1 domain with developer profile : Upgrade not required.
        return false;
        /*if (UpgradeConstants.EDITION_PE.equals(getTargetEdition())) {            
            String sourceVersionAndEdition = getSourceVersionAndEdition();			
            if (UpgradeConstants.VERSION_AS7X_PE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS7X_SE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS7X_EE.equals(sourceVersionAndEdition) ||
                    UpgradeConstants.VERSION_AS81_EE.equals(sourceVersionAndEdition)){
                return true;
            }
        }
        return false;*/
    }
    
    /*public boolean  checkUpgradefrom7xeeto9xee() {
        boolean checkUpgradefrom7xeeto8xee = false;
        if(this.getSourceInstallDir() != null && this.getTargetInstallDir() != null)   {
            checkUpgradefrom7xeeto8xee = UpgradeConstants.VERSION_AS7X_EE.equals(getSourceVersionAndEdition()) && 
                UpgradeConstants.VERSION_AS91_EE.equals(getTargetVersionAndEdition());
        }
        return checkUpgradefrom7xeeto8xee;
    }*/
    
    //START CR 6397215
    /*public boolean  checkUpgradefrom8xpeto9xpe() {
        boolean checkUpgradefrom8xpeto9xpe = false;
        if(this.getSourceInstallDir() != null && this.getTargetInstallDir() != null)   {
            String sourceVersionAndEdition = getSourceVersionAndEdition();		
            String targetVersionAndEdition = getTargetVersionAndEdition();			
            checkUpgradefrom8xpeto9xpe = (UpgradeConstants.VERSION_AS80_PE.equals(sourceVersionAndEdition) ||
                                          UpgradeConstants.VERSION_AS81_PE.equals(sourceVersionAndEdition) ||
                                          UpgradeConstants.VERSION_AS82_PE.equals(sourceVersionAndEdition)) &&
                                          (UpgradeConstants.VERSION_AS90_PE.equals(targetVersionAndEdition) ||
                                          UpgradeConstants.VERSION_AS91_PE.equals(targetVersionAndEdition));
        }
        return checkUpgradefrom8xpeto9xpe;
    }*/
    //END CR 6397215
   
    //Added for CR 6468082 
    public boolean checkUpgradefrom8xpeto9x() {
        boolean checkUpgradefrom8xpeto9x = false;
        String sourceVersionAndEdition = getSourceVersionAndEdition();		
        String targetVersion = getTargetVersion();			
        checkUpgradefrom8xpeto9x = (UpgradeConstants.VERSION_AS80_PE.equals(sourceVersionAndEdition) ||
                                    UpgradeConstants.VERSION_AS81_PE.equals(sourceVersionAndEdition) ||
                                    UpgradeConstants.VERSION_AS82_PE.equals(sourceVersionAndEdition)) && 
                                    UpgradeConstants.VERSION_91.equals(targetVersion);
        return checkUpgradefrom8xpeto9x;
    }

    public boolean checkUpgradefrom8xeeto9x() {
        boolean checkUpgradefrom8xeeto9x = false;
        String sourceVersionAndEdition = getSourceVersionAndEdition();
        String targetVersion = getTargetVersion();
        checkUpgradefrom8xeeto9x = (UpgradeConstants.VERSION_AS81_EE.equals(sourceVersionAndEdition) ||
                                    UpgradeConstants.VERSION_AS82_EE.equals(sourceVersionAndEdition)) &&
                                    UpgradeConstants.VERSION_91.equals(targetVersion);
        return checkUpgradefrom8xeeto9x;
    }
 
    public boolean checkUpgradefrom9xpeto9x() {
        boolean checkUpgradefrom9xpeto9x = false;
        String sourceVersionAndEdition = getSourceVersionAndEdition();		
        String targetVersion = getTargetVersion();			
        checkUpgradefrom9xpeto9x = UpgradeConstants.VERSION_AS90_PE.equals(sourceVersionAndEdition) &&
                                   UpgradeConstants.VERSION_91.equals(targetVersion);
        return checkUpgradefrom9xpeto9x;
    }

    public boolean checkUpgrade8xto9x() {
        boolean checkUpgrade8xto9x = false;
        checkUpgrade8xto9x = checkUpgradefrom8xpeto9x() ||
                             checkUpgradefrom8xeeto9x();
        return checkUpgrade8xto9x;
    }

    public boolean checkUpgrade9xto9x() {
        boolean checkUpgrade9xto9x = false;
        checkUpgrade9xto9x = checkUpgradefrom9xpeto9x();
        return checkUpgrade9xto9x;
    }

    //End - Added for CR 6468082 


    public void enlistDomainsFromSource(java.util.List domains){
        if(domains == null)
            this.enlistDomainsFromSource();
        if(enlistDomain)
            return;
        this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomainsFromUserDefinedDirectories(domains));
        this.enlistDomain=true;
    }
    
    public void enlistDomainsFromSource(){
        if( getSourceInstallDir() == null) {
            return;
        }
        if(enlistDomain)
            return;
        //Admin credential changes. Added for CR 6454007
        if(UpgradeConstants.VERSION_7X.equals(getSourceVersion())){
            //Commented for CR 6486068	
            //User passwords are no longer used. Instead user is prompted for admin credentials.			
            /*String passwordFileProperty = System.getProperty("com.sun.aas.userpasswords");
            if(passwordFileProperty == null) {
                System.out.println(stringManager.getString("enterprise.tools.upgrade.passwordFileMissing"));
                System.exit(1);
            } else {
                File userPwdFile = new File(passwordFileProperty);
                if(!userPwdFile.exists()) {
                    //Display error message
                    System.out.println(stringManager.getString("enterprise.tools.upgrade.passwordFileMissing"));
                    System.exit(1);
                } else {
                    //Retrieve all passwords from file and store in commonInfoModel Object
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(userPwdFile));
                        while(reader.ready()) {
                            String s = reader.readLine();
                            String dName = s.substring(0, s.indexOf(":"));
                            String dValues = s.substring(s.indexOf(":")+1, s.length());
                            this.setDomainCredentials(dName, dValues);
                        }
                    } catch (Exception e) {
                        logger.severe(stringManager.getString("command.generalException") +
                            " " + e.getMessage());
                    }
                }
            }*/
            //End - comment			
            //Added - end
            this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlist70DomainsFromSource(this));
        }else{
            // Determine domains from domains directory....
           // String sourceDomainRoot="";
            if(sourceIsDomain()){
                String source = getSourceInstallDir();
                if(source.endsWith(File.separator)) {
                    source = source.substring(0,source.length() - File.separator.length());
                }
                String domainName = source.substring(source.lastIndexOf(File.separator) + File.separator.length(), source.length());
                String domainRoot = source.substring(0,source.lastIndexOf(domainName) - File.separator.length());
                setSourceDomainRoot(domainRoot);
                //setTargetDomainRoot(domainRoot);
                setSourceDomainRootFlag(true);
                setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomains(this, new String [] {domainName}, domainRoot));
            } else {
                if(this.getSourceDomainRootFlag()) {
                    setSourceDomainRoot(this.getSourceInstallDir());
                } else {
                    setSourceDomainRoot(this.getSourceInstallDir()+File.separator+"domains");
                }
                this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomainsFromDomainsDirectory(this,this.getSourceDomainRoot()));
            }
            enlistDomain=true;
        }
    }
    
    private boolean sourceIsDomain() {
        return UpgradeUtils.getUpgradeUtils(this).checkSourceInputAsDomain();
    }
    public boolean checkSourceInputAsDomainRoot(String source) {
        return UpgradeUtils.getUpgradeUtils(this).checkSourceInputAsDomainRoot(source,this);
    }
    public boolean isValid70Domain(String domainPath) {
        return UpgradeUtils.getUpgradeUtils(this).isValid70Domain(domainPath);
    }
    
    public boolean getSourceDomainRootFlag() {
        return sourceInputAsDomainRoot;
    }
    // This method is called by UpgradeUtils
    public void setSourceDomainRootFlag(boolean fl) {
        this.sourceInputAsDomainRoot = fl;
    }
    public void printInfo(){
        
        getDefaultLogger().finest("SOURCE_INSTALL_DIR=="+SOURCE_INSTALL_DIR);
        getDefaultLogger().finest("SOURCE_INSTALL_DIR=="+TARGET_INSTALL_DIR);
        int size = domainList.size();
        for(int i=0;i<size;i++) {
            String domainName = (String)domainList.get(i);
            getDefaultLogger().finest("**********" + domainName + "****************");
            getDefaultLogger().finest("NSSPWD=="+ domainNSSPwdMapping.get(domainName));
            getDefaultLogger().finest("JKSPWD=="+ domainJKSPwdMapping.get(domainName));
            getDefaultLogger().finest("********************************************");
        }
        
    }
    public String getSourceServerPolicyFileName(){
        if(UpgradeConstants.VERSION_7X.equals(getSourceVersion())){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"server.policy" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"server.policy" ;
        }
        // return getSourceInstancePath()+File.separator+"config"+File.separator+"server.policy" ;
    }
    public String getTargetServerPolicyFileName(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"server.policy" ;
    }
    public String getSourceDefaultWebXMLFileName(){
        if(UpgradeConstants.VERSION_7X.equals(getSourceVersion()) || 
                UpgradeConstants.VERSION_AS81_SE.equals(getSourceVersionAndEdition())){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"default-web.xml" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"default-web.xml" ;
        }
        //return getSourceInstancePath()+File.separator+"config"+File.separator+"default-web.xml" ;
    }
    public String getTargetDefaultWebXMLFileName(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"default-web.xml" ;
    }
    public String getSourceSunACCFileName(){
        if(UpgradeConstants.VERSION_7X.equals(getSourceVersion()) || 
                UpgradeConstants.VERSION_AS81_SE.equals(getSourceVersionAndEdition())){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
        }
        //return getSourceInstancePath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
    }
    public String getTargetSunACCFileName(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
    }
    public String getSourceConfigXMLFile(){
        if(UpgradeConstants.VERSION_7X.equals(getSourceVersion()) || 
                UpgradeConstants.VERSION_AS81_SE.equals(getSourceVersionAndEdition())){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"server.xml" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"domain.xml" ;
        }
    }
    public String getTargetConfigXMLFile(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"domain.xml" ;
    }
    
    public String getSourceVersionAndEdition(){
        if(this.sourceVersionEdition == null){
            //Fix for CR 6440710	
            String sourceInstallDir = this.getSourceInstallDir();			
            if(sourceInstallDir != null) {			
                //End - fix 6440710				
                if(sourceInstallDir.equals(this.getTargetInstallDir()) ) {
                    this.sourceVersionEdition = new VersionExtracter(
                            this.getSourceInstallDir(),this).extractVersionFromConfigFile();
           // if(getSourceInstallDir() != null){
               // this.sourceVersionEdition = new VersionExtracter(this.getSourceInstallDir(),this).getVersion();
                }					
                else {
                    this.sourceVersionEdition =
                            new VersionExtracter(this.getSourceInstallDir(),this).getVersion();
                    //return "UNKNOWN";
                }
            }				
        }
        return this.sourceVersionEdition;
    }
    /*public String getTargetVersionAndEdition(){
        //if(this.targetVersionEdition == null){
            this.targetVersionEdition = new VersionExtracter(this.getTargetInstallDir(),this).getVersion();
        //}
        return this.targetVersionEdition;
    }
    //Method not needed.    
    public void setTargetVersionAndEdition(String verEd){
        // This method is called from UpgradeToolMain
        if("AS90PE".equals(verEd)){
            this.targetVersionEdition = UpgradeConstants.VERSION_AS90_PE;
        }else{
            // There is no difference between SE and EE
            //Added for CR 6468082
            this.targetVersionEdition = UpgradeConstants.VERSION_AS91_EE;			
            //this.targetVersionEdition = UpgradeConstants.VERSION_AS90_EE;
            //End - CR 6468082			
        }
    }*/
    public void clearSourceAndTargetVersions(){
        // this method is called from MainFrame.java.  Need to set this to null after validation is done.
        this.sourceVersionEdition = null;
        //this.targetVersionEdition = null;
    }
    public String getSourceVersion(){
        return UpgradeUtils.getUpgradeUtils(this).versionString(this.getSourceVersionAndEdition());
    }
    public String getTargetVersion(){
        //return UpgradeUtils.getUpgradeUtils(this).versionString(this.getTargetVersionAndEdition());
        if(targetVersion == null) {        
            targetVersion = new VersionExtracter(this.getTargetInstallDir(), this).getVersion();
        }
        return targetVersion;	
    }
    public String getSourceEdition(){
        return UpgradeUtils.getUpgradeUtils(this).editionString(this.getSourceVersionAndEdition());
    }
    /*public String getTargetEdition(){
        return UpgradeUtils.getUpgradeUtils(this).editionString(this.getTargetVersionAndEdition());
    }*/
    public String getTargetDefaultProfile() {
        if(targetDefaultProfile == null) {	    
            targetDefaultProfile = new VersionExtracter(this.getTargetInstallDir(), this).getTargetDefaultProfile();
        }
        return targetDefaultProfile;	
    }	
    public boolean isUpgradeSupported(){
        /*if (getTargetVersionAndEdition().equals(getSourceVersionAndEdition())) {
            logger.info(stringManager.getString("sameVersionUpgradeNotRequired"));
            return false;
        }
        return ((java.util.HashSet)UpgradeConstants.supportMap.get(getSourceVersionAndEdition())).contains(getTargetVersionAndEdition());*/
        String sourceVersionAndEdition = getSourceVersionAndEdition();	    
        String sourceVersion = UpgradeUtils.getUpgradeUtils(this).versionString(sourceVersionAndEdition);
        String sourceEdition = UpgradeUtils.getUpgradeUtils(this).editionString(sourceVersionAndEdition);
        String targetVersion = getTargetVersion();
        String targetDefaultProfile = getTargetDefaultProfile();

        //Same version : No upgrade required.	 
        if(sourceVersion.equals(targetVersion)) {
            logger.log(Level.INFO, stringManager.getString("sameVersionUpgradeNotRequired"));
            return false;
        }
   
        //Check if the Source version and edition supports this version upgrade.	
        if(!((java.util.HashSet)UpgradeConstants.supportMap.get(sourceVersionAndEdition)).contains(targetVersion)) {
            logger.info(stringManager.getString("upgrade.common.upgrade_not_supported"));		
            return false;
        }	    

        //Edition Profile checks for upgrade support
        if(UpgradeConstants.EDITION_EE.equals(sourceEdition)) {
            if(UpgradeConstants.DEVELOPER_PROFILE.equals(targetDefaultProfile)) {
                //Case where 9.1PE stand-alone installer has been used to install target
                if(!isInPlace()) {
                    if(isNssHadbFound()) {
                        //8.xEE to 9.1 enterprise profile upgrade SBS mode
                        return true;
                    } else {
                        //8.xEE to 9.1 developer profile upgrade SBS mode
                        logger.info(
                            stringManager.getString("upgrade.common.upgrade_not_supported_EEDeveloperSBS"));
                        return false;
                    }
                } else {
                    //In-place upgrade : NSS/HADB always found
                    logger.info(stringManager.getString("upgrade.common.enterprise_profile_created"));
                    return true;
                }
            } else {
                //Case where 9.1EE stand-alone installer has been used to install target
                //Default profile will always be enterprise
                return true;
            }
        } else if(UpgradeConstants.EDITION_PE.equals(sourceEdition)) {
            logger.log(Level.INFO, stringManager.getString("upgrade.common.developerProfileCreated"));
            return true;
        } else {
            //Any other Source Edition Not supported.
            logger.info(stringManager.getString("upgrade.common.upgrade_not_supported")); 
            return false;
        }	    
    }
    public String getCurrentCluster(){
        return this.currentCluster;
    }
    public void setCurrentCluster(String clu){
        this.currentCluster = clu;
    }
    public String findLatestDomainDir(String domainRoot) {
        return UpgradeUtils.getUpgradeUtils(this).findLatestDomainDir(domainRoot,currentDomain);
    }
    public String getAdminUserName(){
        //if(!checkUpgrade8xto9x() && !checkUpgrade9xto9x()) {
            return this.adminUserName;
        //} else {
        //    return this.AS_ADMIN_USER;
        //}
    }
    
    public void setAdminUserName(String adminUserName){
        this.adminUserName=adminUserName ;
    }
    
    public String getAdminPassword(){
        return this.adminPassword;
    }
    
    public void setAdminPassword(String adminPassword){
        this.adminPassword = adminPassword;
    }
   
    //Admin credential changes. Added for CR 6454007
    //Commented for CR 6486068
    //Admin credentials are prompted for from the user.	
    /*public String getPasswordFile(String domainName) {
        File tmpPasswordFile = new File("ugpw-"+domainName+".pass");
	if(!checkUpgrade8xto9x() && !checkUpgrade9xto9x()) {
	    DomainInfo dInfo = (DomainInfo) this.getDomainMapping().get(domainName);
	    this.setAdminUserName(dInfo.getDomainAdminUser());
	}
        if(tmpPasswordFile.exists()) {
            return tmpPasswordFile.getAbsolutePath();
        } else {
            try {
                boolean fileCreated = tmpPasswordFile.createNewFile();
                if(fileCreated) {
                    FileWriter writer = new FileWriter(tmpPasswordFile);
                    //Setting the default values for the admin
                    // user name, adminpassword and master password for 8.x PE -> 8.x EE
                    if(checkUpgrade8xto9x()|| checkUpgrade9xto9x()) {
                        writer.write("AS_ADMIN_PASSWORD=" + AS_ADMIN_ADMINPASSWORD +"\n");
                        writer.write("AS_ADMIN_ADMINPASSWORD=" + AS_ADMIN_ADMINPASSWORD +"\n");
                        writer.write("AS_ADMIN_MASTERPASSWORD=" + AS_ADMIN_MASTERPASSWORD + "\n");
                    } else {
                        //get from domain info object and set in the temp file
                        DomainInfo dInfo = (DomainInfo) this.getDomainMapping().get(domainName);
                        writer.write("AS_ADMIN_PASSWORD=" + dInfo.getDomainAdminPassword() +"\n");
                        writer.write("AS_ADMIN_ADMINPASSWORD=" + dInfo.getDomainAdminPassword() +"\n");
                        writer.write("AS_ADMIN_MASTERPASSWORD=" + AS_ADMIN_MASTERPASSWORD + "\n");
                    }
                    writer.close();
                    this.addPasswordFile(tmpPasswordFile.getAbsolutePath());
                    return tmpPasswordFile.getAbsolutePath();
                }
            } catch (IOException ioe) {
                logger.severe(stringManager.getString("command.generalException") + " " + ioe.getMessage());
            }
        }
        return null;
    }*/
    //End - comment	
 
    public String getPasswordFile() {
        if (passwordFilePath == null) {
            try {
                passwordFile = java.io.File.createTempFile("ugpw", null);
                FileWriter writer = new FileWriter(passwordFile);
                //Setting the default values for the admin
                // user name, adminpassword and master password for 8.x PE -> 8.x EE
                /*if(checkUpgradefrom8xpeto9xee()) {
                    writer.write("AS_ADMIN_PASSWORD=" + AS_ADMIN_ADMINPASSWORD +"\n");
                    writer.write("AS_ADMIN_ADMINPASSWORD=" + AS_ADMIN_ADMINPASSWORD +"\n");
                    writer.write("AS_ADMIN_MASTERPASSWORD=" + AS_ADMIN_MASTERPASSWORD + "\n");
                } else {*/
                    writer.write("AS_ADMIN_PASSWORD=" + getAdminPassword() +"\n");
                    writer.write("AS_ADMIN_ADMINPASSWORD=" + getAdminPassword() +"\n");
                    writer.write("AS_ADMIN_MASTERPASSWORD=" + getMasterPassword() + "\n");
                //}
                writer.close();
                passwordFilePath = passwordFile.getAbsolutePath();
            } catch (IOException ioe) {
                logger.severe(stringManager.getString("command.generalException") + " " + ioe.getMessage());
                
            }
        }
        return passwordFilePath;
    }
    
    public void setPasswordsFromFile(String path) {
        try {
            File userPasswordFile = new File(path);
            BufferedReader reader = new BufferedReader(new FileReader(userPasswordFile));
            while( reader.ready() ) {
                String line = reader.readLine();
                if ( line.startsWith("AS_ADMIN_PASSWORD=") ) {
                    setAdminPassword(line.substring(line.indexOf("=") + 1));
                } else if ( line.startsWith("AS_ADMIN_ADMINPASSWORD=") ) {
                    setAdminPassword(line.substring(line.indexOf("=") + 1));
                } else if ( line.startsWith("AS_ADMIN_MASTERPASSWORD=") ) {
                    setMasterPassword(line.substring(line.indexOf("=") + 1));
                }
            }
            reader.close();
        } catch (Exception e) {
            logger.severe(stringManager.getString("command.generalException") + " " + e.getMessage());
        }
    }
    
    public void setMasterPassword(String pw) {
        masterPassword = pw;
    }
    public String getMasterPassword() {
        return masterPassword;
    }
    
    public void deletePasswordFile() {
        if (passwordFile != null) {
            passwordFile.delete();
        }
    }
    
    public String getSourceInitConfFileName(){
        if(UpgradeConstants.VERSION_7X.equals(getSourceVersion())) {
            return getSourceInstancePath()+File.separator+"config"+File.separator+"init.conf" ;
        }else{
            return null;
        }
    }
    
    public void recover() {
        UpgradeUtils.getUpgradeUtils(this).recover();
    }
    public boolean processClinstnceConfFiles(Vector files){
        return ClustersInfoManager.getClusterInfoManager().processClinstanceConfFiles(files);
    }

    public String getSourceWssServerConfigXML(){
        if(UpgradeConstants.VERSION_7X.equals(getSourceVersion()) ||
                UpgradeConstants.VERSION_AS81_SE.equals(getSourceVersionAndEdition())){
            return getSourceInstancePath() + File.separator + "config"
                    + File.separator + "wss-server-config.xml" ;
        } else {
            return getSourceDomainPath() + File.separator + "config"
                    + File.separator + "wss-server-config.xml" ;
        }
    }

    public String getTargetWssServerConfigXML(){
        return getDestinationDomainPath() + File.separator + "config"
            + File.separator + "wss-server-config.xml" ;
    }

    //Added - start CR 6426419
    public void setSourceApplicationRoot(String applRoot) {
        this.sourceApplicationRoot = applRoot;
    }

    public String getSourceApplicationRoot() {
        return this.sourceApplicationRoot;
    }
    //Added - end CR 6426419

    //Admin credential changes. Added for CR 6454007
    public void setDomainCredentials(String dName, String dValues) {
        domainCredentials.put(dName, dValues);
    }

    public String getDomValuesFromPasswordFile(String domainName) {
        return (String)domainCredentials.get(domainName);
    }

    public void addPasswordFile(String passwordFile) {
        passwordFileList.add(passwordFile);
    }

    public List getPasswordFileList() {
        return passwordFileList;
    }
    
    //Added - end

    //Added for CR 6480041
    /**
      * Method to build the ClusterInfo object required for processing clusters.
      */	  
    public void processDomainXmlForClusters() {
        ClustersInfoManager.getClusterInfoManager().gatherClusterInfo(this);
    }
    //End - added

    public boolean isNssHadbFound() {     
        String strHadbDir = getTargetInstallDir() + File.separator + "hadb";	    
        File hadbDir = new File(strHadbDir);
	if(!hadbDir.exists()) {
	    return false;
        } else {
            String[] hadbList = hadbDir.list();
            if((hadbList == null)||(hadbList.length <= 0)){
                // not a valid directory
                return false;
            }else{
                String strHadbmJarFile = strHadbDir + File.separator + hadbList[0] +
                    File.separator + "lib" + File.separator + "hadbm.jar";
                File hadbmJarFile = new File(strHadbmJarFile);
                if(!hadbmJarFile.exists()) {
                    return false;
                }
            }
        }
        return true;
    }	
    
}
