/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * VersionExtracter.java
 *
 * Created on March 8, 2004, 2:23 PM
 */

package com.sun.enterprise.tools.upgrade.common;


/**
 *
 * @author  prakash
 */
import java.io.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.logging.*;
import java.util.logging.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionExtracter {

    private String installDir;

    private StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.common");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private CommonInfoModel common;

    /** Creates a new instance of VersionExtracter */
    public VersionExtracter(String iD,CommonInfoModel common) {
        this.installDir = iD;
        this.common = common;
    }
    /*
     * Returns a version no. and edition info. if 8.x
     * returns only version info if 9.1
     * Returns null, if version cannot be retrived.
     */
    public String getVersion() {
        String appserverVersion = null;
        //Domain not present in the target.
        String asadminString = "asadmin";
        if(System.getProperty("os.name").indexOf("indows") != -1){
            asadminString = "asadmin.bat";
        }
        String asAdminFileStr = this.installDir+File.separator+"bin"+File.separator+asadminString;
        if(new File(asAdminFileStr).exists()){
            String execCommand = asAdminFileStr+" version";
            try{
                java.lang.Process asadminProcess = Runtime.getRuntime().exec(execCommand);
                BufferedReader pInReader = new BufferedReader(new InputStreamReader(asadminProcess.getInputStream()));
                String inLine = null;
                while((inLine = pInReader.readLine()) != null){
                    if((appserverVersion = this.parseVersion(inLine)) != null)
                        break;
                }
                asadminProcess.destroy();
            }catch(Exception ex){
                // returns null if any exception
                logger.log(Level.SEVERE, stringManager.getString("common.versionextracter.getVersionError"), ex);
            }
        }
        if(appserverVersion == null) {
              appserverVersion = extractVersionFromConfigFile();
        }
        return appserverVersion;
    }
    private String parseVersion(String versionString){
        String appservString = stringManager.getString("common.versionextracter.appserver.string");
        String app7String = stringManager.getString("common.versionextracter.appserver.7string");
        if((versionString.indexOf(appservString) != -1) && (versionString.indexOf(app7String) != -1)){
            // Try extracting the string from configFile.
            String verEdString = extractVersionFromConfigFile();
            if(verEdString != null)
                return verEdString;
            else
                return UpgradeConstants.VERSION_AS7X_PE;
        }
        String app80String = stringManager.getString("common.versionextracter.appserver.80string");
        String appPEString = stringManager.getString("common.versionextracter.appserver.platformEdition");
        String appSEString = stringManager.getString("common.versionextracter.appserver.standardEdition");
        String appEEString = stringManager.getString("common.versionextracter.appserver.enterpriseEdition");
        if((versionString.indexOf(appservString) != -1) && (versionString.indexOf(app80String) != -1)){
            if(versionString.indexOf(appPEString) != -1){
                return UpgradeConstants.VERSION_AS80_PE;
            }else if(versionString.indexOf(appSEString) != -1){
                // Do we have 80 SE?
                return UpgradeConstants.VERSION_AS81_SE;
            }else if(versionString.indexOf(appEEString) != -1){
                // Do we have 80 EE?
                return UpgradeConstants.VERSION_AS81_EE;
            }
            return null;
        }
        String app81String = stringManager.getString("common.versionextracter.appserver.81string");
        if((versionString.indexOf(appservString) != -1) && (versionString.indexOf(app81String) != -1)){
            if(versionString.indexOf(appPEString) != -1){
                return UpgradeConstants.VERSION_AS81_PE;
            }else if(versionString.indexOf(appSEString) != -1){
                // Do we have 81 SE?
                return UpgradeConstants.VERSION_AS81_SE;
            }else if(versionString.indexOf(appEEString) != -1){
                // Do we have 81 EE?
                return UpgradeConstants.VERSION_AS81_EE;
            }
            return null;
        }
        String app90String = stringManager.getString("common.versionextracter.appserver.90string");
        if((versionString.indexOf(appservString) != -1) && (versionString.indexOf(app90String) != -1)){
            if(versionString.indexOf(appPEString) != -1){
                return UpgradeConstants.VERSION_AS90_PE;
            }else if(versionString.indexOf(appSEString) != -1){
                // Do we have 82 SE?
                return UpgradeConstants.VERSION_AS90_SE;
            }else if(versionString.indexOf(appEEString) != -1){
                return UpgradeConstants.VERSION_AS90_EE;
            }
            return null;
        }
        //Added for CR 6468082
        String app91String = stringManager.getString("common.versionextracter.appserver.91string");
        if((versionString.indexOf(appservString) != -1) && (versionString.indexOf(app91String) != -1)){
            //Edition deprecated. Hence return only version
            return UpgradeConstants.VERSION_91;		
            /*String version = UpgradeConstants.VERSION_91;
            String edition = null;
            if(isEnterpriseEdition()) {
                edition = UpgradeConstants.EDITION_EE;
	    } else {
                edition = UpgradeConstants.EDITION_PE;
            }
            return formatVersionEditionStrings(new String[]{version,edition});*/
        }
        String app82String = stringManager.getString("common.versionextracter.appserver.82string");
        if((versionString.indexOf(appservString) != -1) && (versionString.indexOf(app82String) != -1)){
            if(versionString.indexOf(appPEString) != -1){
                return UpgradeConstants.VERSION_AS82_PE;
            }else if(versionString.indexOf(appSEString) != -1){
                return UpgradeConstants.VERSION_AS82_SE;
            }else if(versionString.indexOf(appEEString) != -1){
                return UpgradeConstants.VERSION_AS82_EE;
            }
            return null;
        }
        //End - CR 6468082
        return null;
    }
    public String formatVersionEditionStrings(String[] verEd){
        if(verEd != null){
            if(verEd[0].equals(UpgradeConstants.VERSION_7X)){
                if(verEd[1].equals(UpgradeConstants.EDITION_PE)){
                    return UpgradeConstants.VERSION_AS7X_PE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_SE)){
                    return UpgradeConstants.VERSION_AS7X_SE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_EE)){
                    return UpgradeConstants.VERSION_AS7X_EE;
                }
            }else if(verEd[0].equals(UpgradeConstants.VERSION_80)){
                if(verEd[1].equals(UpgradeConstants.EDITION_PE)){
                    return UpgradeConstants.VERSION_AS80_PE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_SE)){
                    return UpgradeConstants.VERSION_AS80_SE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_EE)){
                    return UpgradeConstants.VERSION_AS81_EE;
                }
            }else if(verEd[0].equals(UpgradeConstants.VERSION_81)){
                if(verEd[1].equals(UpgradeConstants.EDITION_PE)){
                    return UpgradeConstants.VERSION_AS81_PE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_SE)){
                    return UpgradeConstants.VERSION_AS81_SE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_EE)){
                    return UpgradeConstants.VERSION_AS81_EE;
                }
            }else if(verEd[0].equals(UpgradeConstants.VERSION_90)){
                if(verEd[1].equals(UpgradeConstants.EDITION_PE)){
                    return UpgradeConstants.VERSION_AS90_PE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_SE)){
                    return UpgradeConstants.VERSION_AS90_SE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_EE)){
                    return UpgradeConstants.VERSION_AS90_EE;
                }
            //Added for CR 6468082
            }else if(verEd[0].equals(UpgradeConstants.VERSION_91)){
                //Edition strings deprecated. return just the version.		    
                return UpgradeConstants.VERSION_91;		    
                /*if(verEd[1].equals(UpgradeConstants.EDITION_EE)){
                    return UpgradeConstants.VERSION_AS91_EE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_PE)){
                    return UpgradeConstants.VERSION_AS91_PE;
                }*/
            }else if(verEd[0].equals(UpgradeConstants.VERSION_82)){
                if(verEd[1].equals(UpgradeConstants.EDITION_PE)){
	                return UpgradeConstants.VERSION_AS82_PE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_SE)){
                    return UpgradeConstants.VERSION_AS82_SE;
                }if(verEd[1].equals(UpgradeConstants.EDITION_EE)){
                    return UpgradeConstants.VERSION_AS82_EE;
                }
            }
            //End - CR 6468082
        }
        return null;
    }
    public String extractVersionFromConfigFile(){
        String versionString = null;
        String editionString = null;

        File configFile = getConfigFile();
        if(configFile == null || !(configFile.exists()) ) {
            //Domain does not exist in target
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        //factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((org.xml.sax.helpers.DefaultHandler)Class.forName
                ("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(configFile);
            String publicID = adminServerDoc.getDoctype().getPublicId();
            String systemID = adminServerDoc.getDoctype().getSystemId();
            // Mail from Hanu - updated on 06/25 - for 7.1 SE it is sun-server_1_1
            //sun-server_1_0 - AS7.0 PE/SE
            //sun-server_1_1 - AS 7.0 EE and 7.1 SE (updated)
            //sun-server_1_2 - AS 7.1EE (7.1 SE uses sun-server_1_1. There is no 7.1PE)
            String appservString = stringManager.getString("common.versionextracter.appserver.string");
            String app7xPESEString = stringManager.getString("common.versionextracter.appserver.7xPESEConfigString");
            String app70EEString = stringManager.getString("common.versionextracter.appserver.70EEConfigString");
            String app71EEString = stringManager.getString("common.versionextracter.appserver.71EEConfigString");
            if((publicID.indexOf(appservString) != -1) && ((systemID.indexOf(app7xPESEString) != -1))){
                versionString = UpgradeConstants.VERSION_7X;
                // This could be either 7.0PE, 7.0SE. Same binary bits.  Just the licence is upgraded
                editionString = this.getEditionFor70PEAnd70SE(configFile);
            }
            if((publicID.indexOf(appservString) != -1) && (systemID.indexOf(app70EEString) != -1)){
                // Either 7.0EE or 7.1 SE
                versionString = UpgradeConstants.VERSION_7X;
                //editionString = UpgradeConstants.EDITION_EE;
                editionString = this.getEditionFor70EEAnd71SE(adminServerDoc);
            }
            if((publicID.indexOf(appservString) != -1) && (systemID.indexOf(app71EEString) != -1)){
                // 7.1 EE
                versionString = UpgradeConstants.VERSION_7X;
                editionString = UpgradeConstants.EDITION_EE;
            }
            String app80String = stringManager.getString("common.versionextracter.appserver.80ConfigString");
            if((publicID.indexOf(appservString) != -1) && (systemID.indexOf(app80String) != -1)){
                versionString = UpgradeConstants.VERSION_80;
                // There is no SE or EE.  There is only 80 PE.
                editionString = UpgradeConstants.EDITION_PE;
            }
            String app81String = stringManager.getString("common.versionextracter.appserver.81ConfigString");
            if((publicID.indexOf(appservString) != -1) && (systemID.indexOf(app81String) != -1)){
                versionString = UpgradeConstants.VERSION_81;
            }
            String app90String = stringManager.getString("common.versionextracter.appserver.90ConfigString");
            if((publicID.indexOf(appservString) != -1) && (systemID.indexOf(app90String) != -1)){
                versionString = UpgradeConstants.VERSION_90;
            }
            String app91String = stringManager.getString("common.versionextracter.appserver.91ConfigString");
            if((publicID.indexOf(appservString) != -1) && (systemID.indexOf(app91String) != -1)){
                versionString = UpgradeConstants.VERSION_91;
		/*//Check if NSS/HADB is in the lib dir. If so update editionString to EDITION_EE
		//else editionString=EDITION_PE
		if(isEnterpriseEdition()) {
		    editionString = UpgradeConstants.EDITION_EE;
		} else {
		    editionString = UpgradeConstants.EDITION_PE;
		}*/
            }
            // Check for edition.
            if(editionString == null && !(UpgradeConstants.VERSION_91.equals(versionString))){
                NodeList taggedElements = adminServerDoc.getDocumentElement().getElementsByTagName("jvm-options");
                for(int lh =0; lh < taggedElements.getLength(); lh++){
                    Element element = (Element)taggedElements.item(lh);
                    String jvmOptionsData = getTextNodeData(element);
                    if(versionString.equals(UpgradeConstants.VERSION_7X)){
                        if((jvmOptionsData.indexOf("EEORBInitializer") != -1) || (jvmOptionsData.indexOf("EEIIOPSocketFactory") != -1)){
                            // for 7X EE is already found from its dtd version.  only need to find if it is SE
                            editionString = UpgradeConstants.EDITION_SE;
                            break;
                        }
                    }else{
                        if((jvmOptionsData.indexOf("EEPluggableFeatureImpl") != -1)){
                            editionString = UpgradeConstants.EDITION_EE;
                            break;
                        }
                    }
                }
                // if EE is not found set to PE by default.  We still need to know how to differentiate SE and EE
                if(editionString == null){
                    editionString = UpgradeConstants.EDITION_PE;
                }
            }
            return formatVersionEditionStrings(new String[]{versionString,editionString});
        }catch (Exception ex){
            logger.log(Level.SEVERE, stringManager.getString("upgrade.transform.startFailureMessage"),ex);
            //throw new HarnessException(stringManager.getString("upgrade.transform.startFailureMessage"));
        }
        return null;
    }
    private String getEditionFor70PEAnd70SE(File configFile){
        // Since binary bits are same and the only difference is lincence upgrade, check for multiple instances.  If there are multiple instances
        // then it is SE, otherwise assume PE.
        String editionString = UpgradeConstants.EDITION_PE;
        java.util.Hashtable domainMapping = this.extractDomainsMapping();
        if(domainMapping != null && !domainMapping.isEmpty()){
            for(java.util.Iterator dIt = domainMapping.values().iterator(); dIt.hasNext(); ){
                DomainInfo dInfo = (DomainInfo)dIt.next();
                // If this domain has more than one instance, then it should be SE.
                if(dInfo.getInstanceNames().size() > 2)
                    return UpgradeConstants.EDITION_SE;
            }
            return UpgradeConstants.EDITION_PE;
        }else{
            // This will be the case of inplace upgrade or sols 10 integration.,
            String domainsDir = getDomainAndConfigDirs()[0];
            File domains[] = new File(domainsDir).listFiles();
            if(domains != null){
                for(int i=0; i < domains.length; i++){
                    // check if the item is a directory.
                    if(domains[i].isDirectory()){
                        // Get no. of instances in the directory.
                        if(domains[i].list().length > 2 && common.isValid70Domain(domains[i].getPath()))
                            return UpgradeConstants.EDITION_SE;
                    }
                }
                return UpgradeConstants.EDITION_PE;
            }
        }
        return UpgradeConstants.EDITION_PE;
    }
    private String getEditionFor70EEAnd71SE(Document doc){
        // Both 70EE and 71 EE uses the same dtd.  The differences are 1. EE has availability-service element, 2. EE has jvm-option wiht hadb root, 3. EE has session-config element
        NodeList taggedElements = doc.getDocumentElement().getElementsByTagName("jvm-options");
        for(int lh =0; lh < taggedElements.getLength(); lh++){
            Element element = (Element)taggedElements.item(lh);
            String jvmOptionsData = getTextNodeData(element);
            if((jvmOptionsData.indexOf("com.sun.aas.hadbRoot") != -1)){
                return UpgradeConstants.EDITION_EE;
            }
        }
        NodeList availabilityEles = doc.getDocumentElement().getElementsByTagName("availability-service");
        if(availabilityEles.getLength() != 0)
            return UpgradeConstants.EDITION_EE;
        // This can be uncommented as and when needed.  Not necessary for now.
        //NodeList availabilityEles = doc.getDocumentElement().getElementsByTagName("session-config");
        //if(availabilityEles.getLength() != 0)
            //return UpgradeConstants.EDITION_EE;
        return UpgradeConstants.EDITION_SE;
    }
    private java.util.Hashtable extractDomainsMapping(){
        // If the source is 7.x then it is not guaranteed that domains directory lives under <install_dir>
        // Should create the domainMapping and obtain the config file.
        File runtime70Jar = new File(this.installDir+File.separator+"lib"+File.separator+"admingui.ear");
        boolean notTargetInstallation7x = true;
        //This check is required because target is not given yet as CLI input and target can not be 7.x
        if(common.getTargetInstallDir() !=null)
            notTargetInstallation7x = !(common.getTargetInstallDir().equals(this.installDir));
        /*runtime70Jar != null) ||*/
        if(runtime70Jar.exists() &&!(common.checkSourceInputAsDomainRoot(this.installDir)) && notTargetInstallation7x ) {
            // Its a valid 7.x directory.
            Appserver70DomainNamesResolver as =new Appserver70DomainNamesResolver(this.installDir);
            java.util.Hashtable domainsMapping = as.getDomainNamesPathMapping();
            common.setInstallConfig70(as.getConfigDir70(this.installDir));
            return domainsMapping;
        }
        return null;
    }
    private File getConfigFile(){
        java.util.Hashtable domainMapping = extractDomainsMapping();
        if(domainMapping != null && !domainMapping.isEmpty()){
            DomainInfo dInfo = (DomainInfo)domainMapping.values().iterator().next();
            // admin-server has server.xml that uses sun_server_1_0.dtd where as server1 uses other dtds.  So, lets get server.xml from server1 or other
            String instanceName = null;
            for(java.util.Iterator instIt = dInfo.getInstanceNames().iterator();instIt.hasNext();){
                instanceName = (String)instIt.next();
                if(!instanceName.equals("admin-server"))
                    break;
            }
            return new File(dInfo.getInstancePath(instanceName)+File.separator+"config"+File.separator+"server.xml");
        }
        String[] dCDirs = getDomainAndConfigDirs();
        if(dCDirs == null)
            return null;
        if(dCDirs[1].indexOf("server1") != -1){
            return new File(dCDirs[1]+File.separator+"server.xml");
        }else{
            return new File(dCDirs[1]+File.separator+"domain.xml");
        }
    }
    public String[] getDomainAndConfigDirs(){
        String domainsDir = this.installDir+File.separator+"domains";
        String configDir = null;
        boolean domainRootSame = false;
        if(common.checkSourceInputAsDomainRoot(this.installDir))
            domainRootSame = new File(common.getSourceDomainRoot()).equals(new File(common.getTargetDomainRoot()));
        if(common.checkSourceInputAsDomainRoot(this.installDir) && domainRootSame ) {
            if(domainRootSame) {
                //check if "backup dir exists, if yes, go and get the config of latest created domain
                // latest created domain will be the backedup domain.
                if(new File(this.installDir +File.separator +"backup").exists()) {
                    domainsDir = this.installDir;
                    String backupdomainPath = common.findLatestDomainDir(this.installDir);
                    String serverDir = backupdomainPath+File.separator+"server1";
                    if(! (new File(serverDir).exists())){
                        configDir = backupdomainPath+File.separator+"config";
                    }else{
                        configDir = backupdomainPath+File.separator+"server1"+File.separator+"config";
                    }
                } else {    // Now get from domain1, config location
                    String[] directories = new File(this.installDir).list();
                    String domainName = null;
                    for(int j =0;j<directories.length;j++) {
                         if(directories[j].equals("backup") || new File(this.installDir + File.separator + directories[j]).isFile())
                             continue;
                        else {
                             domainName = directories[j];
                             break;
                         }
                    }
                    //domainsDir = this.installDir+File.separator+"domain1";
                    domainsDir = this.installDir+File.separator+domainName;
                    if(! (new File(domainsDir).exists())){
                        // not a valid directory.
                        domainsDir = null;
                        configDir = null;

                    }else{
                        String domainsDir2 = domainsDir+File.separator+"server1";
                        if(! (new File(domainsDir2).exists())){
                            configDir = domainsDir+File.separator+"config";
                        }else{
                            configDir = domainsDir+File.separator+"server1"+File.separator+"config";
                        }
                        // installDir directory itself is domains dir
                        domainsDir = this.installDir;
                    }
                }
            }
        }  else if(! (new File(domainsDir).exists())){
            // inplace upgrade ?
            domainsDir = this.installDir+File.separator+"domains_bak";
            if(! (new File(domainsDir).exists())){
                // solaris 10 integration dir ?
                String[] chList = new File(this.installDir).list();
                //domainsDir = this.installDir+File.separator+"domain1";
                if((chList == null)||(chList.length <= 0)){
                    // not a valid directory.
                    domainsDir = null;
                    configDir = null;
                }else{
                    domainsDir = this.installDir+File.separator+chList[0];
                    if(! (new File(domainsDir+File.separator+"config").exists())){
                        //Checking if input is some domain
                        if(new File(installDir +File.separator +"config").isDirectory()){
                            configDir = installDir+File.separator+"config";
                            domainsDir = installDir;
                        }else {
                        // not a valid directory.
                        domainsDir = null;
                        configDir = null;
                        }
                    }else{
                        String domainsDir2 = domainsDir+File.separator+"server1";
                        if(! (new File(domainsDir2).exists())){
                            configDir = domainsDir+File.separator+"config";
                        }else{
                            configDir = domainsDir+File.separator+"server1"+File.separator+"config";
                        }
                        // installDir directory itself is domains dir
                        domainsDir = this.installDir;
                    }
                }
            }else{
                String[] chList = new File(domainsDir).list();
                configDir = domainsDir+File.separator+chList[0]+File.separator+"config";
            }
        }else{
            String[] chList = new File(domainsDir).list();
            if(chList != null){
                String domainsDir2 = domainsDir+File.separator+chList[0]+File.separator+"server1";
                if(! (new File(domainsDir2).exists())){
                    configDir = domainsDir+File.separator+chList[0]+File.separator+"config";
                }else{
                    configDir = domainsDir+File.separator+chList[0]+File.separator+"server1"+File.separator+"config";
                }
            }
        }
        if(configDir == null){
            return null;
        }
        return new String[]{domainsDir,configDir};
    }
    private String getTextNodeData(Element element){
        NodeList children = element.getChildNodes();
        for(int index=0; index < children.getLength(); index++){
            if(children.item(index).getNodeType() == Node.TEXT_NODE){
                return children.item(index).getNodeValue();
            }
        }
        return null;
    }

    public String getTargetDefaultProfile() {
        String defaultProfile= null;
        try {
            String path = this.installDir + File.separator + "config" + File.separator + "asadminenv.conf";
            File asadminenvFile = new File(path);
            BufferedReader reader = new BufferedReader(new FileReader(asadminenvFile));
            while( reader.ready() ) {
                String line = reader.readLine();
                if ( line.startsWith("AS_ADMIN_PROFILE=") ) {
                    defaultProfile = line.substring(line.indexOf("=") + 1);
                    break;
                } else continue;
            }
            reader.close();
            if(defaultProfile == null) throw new Exception();
        } catch (Exception e) {
            logger.severe(stringManager.getString("command.generalException") + " " + e.getMessage());
            common.recover();	    
            System.exit(2);
        }
        return defaultProfile;
        /*File hadbDir = new File(strHadbDir);
        if(!hadbDir.exists()) {
            return false;
        } else {
            String[] hadbList = hadbDir.list();
            if((hadbList == null)||(hadbList.length <= 0)){
                // not a valid directory
		return false;
            }else{
                String strHadbmJarFile = strHadbDir + File.separator + hadbList[0] +
                        File.separator + "lib" + File.separator + "hadbm.jar";
                File hadbmJarFile = new File(strHadbmJarFile);
                if(!hadbmJarFile.exists()) {
                    return false;
                }
            }
        }
        return true;	*/
    }

    public static void main(String[] args){
       //VersionExtracter ve = new VersionExtracter("C:\\Softwares\\Sun\\AppServer7");
    }

}
