/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
/**
 *
 * @author Hans Hrasna 
 */
public class ARG_masterpassword extends ArgumentHandler {
    
    /** Creates a new instance of ARG_masterpassword */
    public ARG_masterpassword(ParsedArgument pa) {
        super(pa);
        if(parameters.isEmpty()){
            helpUsage(sm.getString("enterprise.tools.upgrade.cli.argument_missing","--masterpassword/-m"));
            System.exit(1);
        }
        String masterpassword = (String)parameters.firstElement();
        commonInfo.setMasterPassword(masterpassword);
        if(!interactiveMap.containsKey("target"))
            return;
        if(!UpgradeConstants.EDITION_PE.equals(commonInfo.getSourceEdition())) {
            if(!utils.validateUserDetails(commonInfo.getAdminUserName(),commonInfo.getAdminPassword(),masterpassword)) {
                _logger.severe(sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword_or_masterpassword"));
                System.exit(1);
            }
        }
        
    }
}
