/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import java.util.Iterator;
import java.util.List;

/**
 *
 * @author Hans Hrasna
 */
public class ARG_noprompt extends ArgumentHandler {
    private String defaultAdminUser = "admin";
    private String defaultAdminPassword = "adminadmin";
    private String defaultMasterPassword = "changeit";
    
    /** Creates a new instance of ARG_noprompt */
    public ARG_noprompt(ParsedArgument pa) {
        super(pa);
        //Silent upgrade support with default values
        if (commonInfo.getAdminUserName() == null){
            commonInfo.setAdminUserName(defaultAdminUser);
            interactiveMap.put(ArgsParser.ADMINUSER,defaultAdminUser);
        }
        if (commonInfo.getAdminPassword() == null){
            commonInfo.setAdminPassword(defaultAdminPassword);
            interactiveMap.put(ArgsParser.ADMINPASSWORD,defaultAdminPassword);
        }
        if (commonInfo.getMasterPassword() == null) {
            commonInfo.setMasterPassword(defaultMasterPassword);
        }
        
        // set up silent certificate upgrade
        commonInfo.setCertificateConversionFlag(true);
        List domainList = commonInfo.getDomainList();
        Iterator it = domainList.iterator();
        while (it.hasNext()){
            //attempt certificate migration for each domain
            String domainName = (String)it.next();
            commonInfo.setCurrentDomain(domainName);
            //commonInfo.setJksCAKeystorePassword(password);
            String password = UpgradeUtils.getUpgradeUtils(commonInfo).getJvmOptionValueFromSourceConfig("javax.net.ssl.keyStorePassword");
            if(password == null) {
                password = commonInfo.getMasterPassword();
            }
            commonInfo.setJksKeystorePassword(password);
            String trustPassword = UpgradeUtils.getUpgradeUtils(commonInfo).getJvmOptionValueFromSourceConfig("javax.net.ssl.trustStorePassword");
            if(trustPassword == null) {
                trustPassword = commonInfo.getMasterPassword();
            }
            commonInfo.setJksCAKeystorePassword(trustPassword);
            commonInfo.addDomainOptionName(domainName);
            interactiveMap.put(ArgsParser.DOMAIN + "-" + commonInfo.getCurrentDomain(), domainName);
            interactiveMap.put(ArgsParser.JKSPWD + "-" + domainName, password);
            interactiveMap.put(ArgsParser.CAPWD + "-" + domainName, password);
            interactiveMap.put(ArgsParser.NSSPWD + "-" + domainName, password);
            interactiveMap.put(ArgsParser.TARGETNSSPWD + "-" + domainName, password);
            commonInfo.setCertDbPassword(commonInfo.getCurrentDomain(), password);
            String jksPath=commonInfo.getSourceJKSKeyStorePath();
            if(!PasswordVerifier.verifyKeystorePassword(jksPath,password )) {
                commonInfo.recover();
                _logger.severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                System.exit(1);
            }
            String trustJksPath = commonInfo.getSourceTrustedJKSKeyStorePath();
            if(!PasswordVerifier.verifyKeystorePassword(trustJksPath,trustPassword)) {
                commonInfo.recover();
                _logger.severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
                System.exit(1);
            }
        }
    }
    
}
