/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import java.util.Vector;
import java.util.logging.*;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.logging.*;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import java.util.Map;
import com.sun.enterprise.util.i18n.StringManager;

/**
 *
 * @author Hans Hrasna
 */
public abstract class ArgumentHandler {
    protected Logger _logger = LogService.getLogger(LogService.UPGRADE_LOGGER);
    protected CommonInfoModel commonInfo;
    protected Vector parameters;
    protected StringManager sm;
    protected UpgradeUtils utils;
    protected Map interactiveMap;
    
    /** Creates a new instance of ArgumentHandler */
    public ArgumentHandler(ParsedArgument pa) {
        commonInfo = pa.getCommonInfo();
        parameters = pa.getParameters();
        sm = StringManager.getManager(LogService.UPGRADE_CLI_LOGGER);
        utils = UpgradeUtils.getUpgradeUtils(commonInfo);
        interactiveMap = pa.getInteractiveMap();
    }
    
    protected void helpUsage(){
        
        System.out.println(sm.getString("enterprise.tools.upgrade.cli.usage"));
        
        if(commonInfo.isUpgradeJKStoNSS() || commonInfo.isUpgradeNSStoJKS()) {
            System.out.println(sm.getString("enterprise.tools.upgrade.cli.convert_certs"));
            System.out.println();
            return;
        }
        
        if(commonInfo.isUpgradeNSStoNSS()) {
            System.out.println(sm.getString("enterprise.tools.upgrade.cli.NSS_certs"));
            System.out.println();
            return;
        }
        
        if(commonInfo.isUpgradeJKStoJKS()) {
            System.out.println(sm.getString("enterprise.tools.upgrade.cli.JKS_certs"));
            System.out.println();
            return;
        }
        System.out.println(sm.getString("enterprise.tools.upgrade.cli.convert_certs"));
        System.out.println();
    }
    
    protected void helpUsage(String msg) {
        System.out.println(msg);
        System.out.println();
        helpUsage();
    }
}
