/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ApplicationRef.java
 *
 * Created on April 12, 2004, 3:37 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Attr;
import java.util.logging.Level;

public class ApplicationRef extends GenericElement {

    /** Creates a new instance of ApplicationRef */
    public ApplicationRef() {
    }
    /**
     * element - application-ref
     * parentSource - server or cluster
     * parentResult - server or cluster
     */
    public void transform(Element element, Element parentSource, Element parentResult){
		logger.log(Level.FINE, stringManager.getString("upgrade.transform.applicationRef.transformingMSG"), parentSource.getTagName());
        if(parentSource.getTagName().equals("cluster")){
            //commented for CR 6480041 - Should transform the app-ref for cluster sub elements.
            //super.transform(element,parentSource,parentResult);
        }else{
            // If parent is server instead of cluster, the application deployment module adds application ref to target server.
        }
    }

}
