/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AuthRealm.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

public class AuthRealm extends BaseElement {
    
    private String parentName;
    /** Creates a new instance of Element */
    public AuthRealm() {
    }
    /**
     * element - auth-realm
     * parentSource - parent http-service of element
     * parentResult - parent http-service of result
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        if(!this.canTransform(element.getAttribute("name"), element.getAttribute("classname")))
            return;
        NodeList resultAuths = parentResult.getElementsByTagName("auth-realm");
        Element resultAuth = null;
        for(int lh =0; lh < resultAuths.getLength(); lh++){
            // Compare id attribute of auth-realm elements.
            if((element.getAttribute("name")).equals(((Element)resultAuths.item(lh)).getAttribute("name"))){
                resultAuth = (Element)resultAuths.item(lh);
                this.transferAttributes(element, resultAuth, null);
                break;
             }
        }
        if(resultAuth == null){
            // Add element - auth-realm to result security-service.
            resultAuth = parentResult.getOwnerDocument().createElement("auth-realm");
            this.transferAttributes(element, resultAuth, null);
            this.parentName = parentResult.getTagName();
            this.appendElementToParent(parentResult,resultAuth);  
        }
        super.transform(element,  parentSource, resultAuth);  
    }  
    private boolean canTransform(String name, String className){
        // FIX... name of solarisRealm is "solaris" not known. Need to finout
	//start CR 6399167 - security's keyfile location should be transformed.
        //if((name.equals("file") || className.equals("com.iplanet.ias.security.auth.realm.file.FileRealm")) ||
	//end CR 6399167
        if((name.equals("ldap") || className.equals("com.iplanet.ias.security.auth.realm.ldap.LDAPRealm")) ||
            (name.equals("solaris") || className.equals("com.iplanet.ias.security.auth.realm.solaris.SolarisRealm")) ||
            (name.equals("certificate") || className.equals("com.iplanet.ias.security.auth.realm.certificate.CertificateRealm"))){
            return false;
        }
        return true;
    }
    protected java.util.List getInsertElementStructure(Element element, Element parentEle){
        java.util.List list = new java.util.ArrayList();
        if(this.parentName != null){
            if(this.parentName.equals("node-agent")){
                list.add("log-service");
            }
        }
        return list;
    }
    
}
