/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Element.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import java.util.logging.Level;

public class LogService extends BaseElement {

    /** Creates a new instance of Element */
    public LogService() {
    }
    /**
     * element - log-service
     * parentSource - parent server of element
     * parentResult - domain
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        // There should only be one or zero http-service
        logger.log(Level.FINE, stringManager.getString("upgrade.transform.transformingMSG", this.getClass().getName(), element.getTagName()));
        NodeList logServs = parentResult.getElementsByTagName("log-service");
        Element logService = null;
        logger.log(Level.FINE, stringManager.getString(this.getClass().getName() +  ":: logServs.getLength() ", logServs.getLength()));
        if(logServs.getLength() == 0){
            NodeList config = parentResult.getElementsByTagName("config");
            logService = parentResult.getOwnerDocument().createElement("log-service");
            this.transferAttributes(element, logService, null);
            this.appendElementToParent((Element)config.item(0),logService);
        }else {
            logService = (Element)logServs.item(0);
            this.transferAttributes(element, logService, null);
        }

        super.transform(element,  parentSource, logService);
    }
    // Over ride the method.
    protected void transferAttributes(Element source, Element result, java.util.List nonTransferList){
        // Transfer only appropriate attributes.
        //result.setAttribute("echo-log-messages-to-stderr", source.getAttribute("echo-log-messages-to-stderr"));

        //result.setAttribute("create-console",source.getAttribute("create-console"));
        //result.setAttribute("log-virtual-server-id",source.getAttribute("log-virtual-server-id"));

        // if source is 8.0 transfer all the elements
        if(commonInfoModel.getSourceVersion().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.VERSION_7X)){
            result.setAttribute("use-system-logging",source.getAttribute("use-system-logging"));
            this.setModuleLevelLogs(source,result);
        }else{
            nonTransferList = new java.util.Vector();
            // You dont want to change the log file name.
            nonTransferList.add("file");
            super.transferAttributes(source, result, nonTransferList);
        }
    }
    private void setModuleLevelLogs(Element sourceLogService, Element resultLogService){
        // This method is called only for AS 7.x.  log-levels are defined for many source attributes, that need to be set to module level. in target
        NodeList modLogLevels = resultLogService.getElementsByTagName("module-log-levels");
        Element moduleLogLevels = null;
        if(modLogLevels.getLength() == 0){
            moduleLogLevels = resultLogService.getOwnerDocument().createElement("module-log-levels");
            resultLogService.appendChild(moduleLogLevels);
        }else{
            moduleLogLevels = (Element)modLogLevels.item(0);
        }
        // ejb-container from source
        //(http-service , iiop-service , admin-service? , web-container , ejb-container , mdb-container , jms-service , log-service , security-service , transaction-service , java-config , resources , applications , availability-service? , property*)
        //root, server, ejb-container, cmp-container, mdb-container, web-container, classloader, configuration, naming, security, jts, jta, admin, deployment, verifier, jaxr, jaxrpc, saaj, corba, javamail, jms, connector, jdo, cmp, util, resource-adapter, synchronization, node-agent
        setLogLevelAttribute(sourceLogService,"ejb-container", "log-level", moduleLogLevels, "ejb-container");
        setLogLevelAttribute(sourceLogService,"web-container", "log-level", moduleLogLevels, "web-container");
        setLogLevelAttribute(sourceLogService,"mdb-container", "log-level", moduleLogLevels, "mdb-container");
        setLogLevelAttribute(sourceLogService,"orb", "log-level", moduleLogLevels, "corba");
        setLogLevelAttribute(sourceLogService,"admin-service", "log-level", moduleLogLevels, "admin");
        setLogLevelAttribute(sourceLogService,"jms-service", "log-level", moduleLogLevels, "jms");
        setLogLevelAttribute(sourceLogService,"log-service", "level", moduleLogLevels, "server");
        setLogLevelAttribute(sourceLogService,"log-service", "level", moduleLogLevels, "root");
        setLogLevelAttribute(sourceLogService,"security-service", "log-level", moduleLogLevels, "security");
        setLogLevelAttribute(sourceLogService,"transaction-service", "log-level", moduleLogLevels, "jts");
    }
    private void setLogLevelAttribute(Element sourceLogService, String srcEle, String srcAttrName, Element moduleLogLevels, String targetAttrName){
        NodeList srcEles = sourceLogService.getOwnerDocument().getElementsByTagName(srcEle);
        if((srcEles != null) && (srcEles.getLength() > 0)){
            String logLevelAttrValue = ((Element)srcEles.item(0)).getAttribute(srcAttrName);
            if((logLevelAttrValue != null) && (!logLevelAttrValue.trim().equals(""))){
                if(logLevelAttrValue.equals("ALERT") || logLevelAttrValue.equals("FATAL")){
                    logLevelAttrValue = "SEVERE";
                }
                moduleLogLevels.setAttribute(targetAttrName, logLevelAttrValue);
            }
        }
    }
}
