/*
 * OnlineBackupSynchronizer.java
 *
 * Created on December 19, 2003, 11:25 PM
 */

package com.sun.enterprise.config.backup.appserver;

import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.pluggable.BackupSynchronizer;
/**
 * AppServer's implementation of locking mechanism for
 * off line backup restore functionality.
 *
 * @author  sridatta
 */
public class OfflineBackupSynchronizer implements BackupSynchronizer {
    
    /** Creates a new instance of OnlineBackupSynchronizer */
    public OfflineBackupSynchronizer() {
    }
    
    /**
     * Check if the server is running or not
     * throw BackupRuntimeException if it cannot be locked
     *
     * Implementation for appserver is pretty simple. Even
     * though we should lock, implementation just checks if
     * server is running. If so, throws a runtime excetpion
     * and aborts the operation.
     * 
     * There is no guarantee that the server will not start up
     * after passing through this operation. 
     */
    public void lock() {
        if(isServerRunning()) {
	    //fixme i18n
            throw new BackupAbortException("error_server_running", "error_server_running");
        }
    }    
    
    public void release() {
    }    
    
    private boolean isServerRunning() {
        return false; //nyi fixme
    }
}
