/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/test/CLISupportSimpleTestee.java,v 1.4 2006/11/10 21:14:45 dpatil Exp $
 * $Revision: 1.4 $
 * $Date: 2006/11/10 21:14:45 $
 */
 
package com.sun.cli.jmx.test;


import java.io.Serializable;
import java.net.URL;
import java.net.URI;

import java.util.Properties;

import javax.management.AttributeChangeNotification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.Notification;


public class CLISupportSimpleTestee 
	extends NotificationBroadcasterSupport
	implements CLISupportSimpleTesteeMBean 
	
{
	volatile long	mNotifMillis	= 1000;
	volatile long	mNumNotifsEmitted;
	EmitterThread	mEmitterThread;
    
		public
	CLISupportSimpleTestee()
	{
	}

	
    	public void
   	test11ObjectArgs( String a1, Boolean a2, Character a3, Byte a4, Short a5,
    			Integer a6, Long a7, Float a8, Double a9,
    			java.math.BigInteger a10, java.math.BigDecimal a11)
    {
    	// no need to do anything
    }
    
    	public void
   	test11MixedArgs( String a1, boolean a2, char a3, byte a4, short a5,
    					int a6, long a7, float a8, double a9,
    					java.math.BigInteger a10, java.math.BigDecimal a11)
    {
    	// no need to do anything
    }
    
    	public String
   	testString( String s )
   	{
   		return( s );
   	}
   	
    	public Object
    testObject( Object obj )
    {
    	return( obj );
    }

    	public Integer
    testInteger( Integer i )    
	{
		return( i );
	}
	
		public int
    test_int( int i )
    {
    	return( i );
    }
    
		public Object []
	testObjectArray( Object [] objects )
	{
		return( objects );
	}
	
	
    	public String
    testcasesensitivity1()
   	{
   		return( "testcasesensitivity1" );
   	}
    	public String
    testCASESENSITIVITY1()
   	{
   		return( "testCASESENSITIVITY1" );
   	}
    	public String
    testCaseSensitivity1()
   	{
   		return( "testCaseSensitivity1" );
   	}
   	
    	public String
    testCaseSensitivity2()
   	{
   		return( "testCaseSensitivity2" );
   	}
   	
   	
   		public URL
    testURL( URL u )
    {
    	return( u );
    }

		public URI
    testURI( URI u )
    {
    	return( u );
    }
    
    
    private static class AintGonnaHaveIt implements Serializable
    {
    		public
    	AintGonnaHaveIt()
    	{
    	}
    };
    
    	public Object
    testUnknownType()
    {
    	return( new AintGonnaHaveIt() );
    }
    	public Object
    getUnknownType()
    {
    	return( new AintGonnaHaveIt() );
    }
	
	
//------------------------------------------------------------------------
							
    public long getNotifMillis()
    {
        return mNotifMillis;
    }

    public void setNotifMillis(long millis)
    {
       	mNotifMillis	= millis;
       	
       	if ( mEmitterThread != null )
       	{
       		// restart with new interval
       		stopNotif();
       		startNotif();
       	}
    }
    
    public long		getNotifsEmitted()
    {
    	return( mNumNotifsEmitted );
    }


    public void resetNotifsEmitted()
    {
    	mNumNotifsEmitted	= 0;
    }

    
    synchronized public void startNotif()
    {
    	stopNotif();
    	
    	System.out.println( "emitting notifications once per this many ms: " + mNotifMillis );
		mEmitterThread	= new EmitterThread( this, mNotifMillis);
		mEmitterThread.start();
    }

    public void stopNotif()
    {
    	if ( mEmitterThread != null )
    	{
    		EmitterThread thread	= mEmitterThread;
    	
    		mEmitterThread	= null;
    		try
    		{
    			thread.join( );
    		}
    		catch( InterruptedException e )
    		{
    		}
		}
    }
    
    boolean emitNotif( EmitterThread thread )
    {
    	if ( mEmitterThread == null )
    	{
    		return( false );
    	}
    		
		final AttributeChangeNotification	notif	= new AttributeChangeNotification( this,
			mNumNotifsEmitted,	// use this as sequence number
			System.currentTimeMillis(),
			"did it again",
			"NotifsEmitted",
			"java.lang.long",
			Long.valueOf(mNumNotifsEmitted),
			Long.valueOf(mNumNotifsEmitted + 1));
		
		++mNumNotifsEmitted;
		
		sendNotification( notif );
		
		System.out.println( "emitted another one" );
		return( true );
    }
}

    
class EmitterThread extends Thread
{
	CLISupportSimpleTestee	mHost;
	final long					mSleepMillis;
	
	EmitterThread( CLISupportSimpleTestee host, long sleepMillis )
	{
		super( "Emitter Thread" );
		mHost	= host;
		mSleepMillis	= sleepMillis;
	}
	
	
		public void
	run()
	{
		boolean	keepGoing	= true;
		
		final long	sleepMillis	= mSleepMillis;
		
		while ( keepGoing )
		{
			if ( sleepMillis != 0 )
			{
				try
				{
					Thread.sleep( sleepMillis );
				}
				catch( InterruptedException e )
				{
				}
			}
			
			keepGoing	= mHost.emitNotif( this );
		}
	}
};



