/*
 * BaseLoggingCommand.java
 *
 * Created on August 1, 2006, 11:34 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.j2ee.J2EEServer;
import java.util.Map;

/**
 *
 * @author prashanth
 */
abstract public class BaseLoggingCommand extends S1ASCommand
{
    private static final String TARGET_OPTION = "target";

    /**
     *  method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        //use http connector
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(),
                                                              getUser(), getPassword());
        String instanceName = getOption(TARGET_OPTION);
        verifyTargetInstance(mbsc, instanceName);
        final String objectName = getObjectName();
        final Object[] params = getParamsInfo();
        final String operationName = getOperationName();
        final String[] types = getTypesInfo();

        try        
        {
            //if (System.getProperty("Debug") != null) printDebug(mbsc, objectName);
            Object returnValue = mbsc.invoke(new ObjectName(objectName),
                                             operationName, params, types);
            handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "CommandSuccessful",
                                                       new Object[] {name}));
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }
    }

    
    protected void verifyTargetInstance(MBeanServerConnection mbsc, String instanceName) 
        throws CommandException
    {
        DomainRoot domainRoot = 
                ProxyFactory.getInstance(mbsc).getDomainRoot();
        boolean isServer=false;
        isServer = domainRoot.getDomainConfig().getServerConfigMap().keySet().contains(instanceName);
        if ( ! isServer ) 
        {
            throw new CommandException(getLocalizedString("TargetNotAnInstance", 
                                                 new Object[] {instanceName}));
        }
        else
        {
            final Map<String,J2EEServer> servers =
                domainRoot.getJ2EEDomain().getJ2EEServerMap();
            J2EEServer server = servers.get( instanceName );

            boolean running = server != null &&
                                server.getstate() == server.STATE_RUNNING || 
                                server.getstate() == server.STATE_STARTING;
            if (!running)
                throw new CommandException(getLocalizedString("InstanceNotRunning",
                                                  new Object[] {instanceName}));
        }        
    }
}
