/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;


/**
 *  This class is the implementation for display-error-distribution command.
 **/

public class DisplayErrorDistributionCommand extends BaseLoggingCommand
{
    private static final String TARGET_OPTION = "target";

    /**
     *  A method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        if (!validateOptions())
            throw new CommandValidationException("Validation is false");
        
        //use http connector
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                              getUser(), getPassword());
        String instanceName = getOption(TARGET_OPTION);
        verifyTargetInstance(mbsc, instanceName);
        final String objectName = getObjectName();
        final String operationName = getOperationName();
        final long timeStamp = Long.valueOf((String) getOperands().get(0)).longValue(); 
        
        try
        {
            // get the modules with SEVERE count
            Object[] params = new Object[]{timeStamp, "SEVERE"};
            String[] types = getTypesInfo();
            Map returnMap = (Map) mbsc.invoke(new ObjectName(objectName), 
                                                operationName, params, types);
            Map errorsMap = handleErrorDistribution(returnMap, 
                                                        new HashMap(), true);
            
            // get the modules with WARNING count
            params = new Object[]{timeStamp, "WARNING"};
            returnMap = (Map) mbsc.invoke(new ObjectName(objectName), 
                                                operationName, params, types);
            errorsMap = handleErrorDistribution(returnMap, errorsMap, false);

            //Display the error distribution
            displayErrorDistribution(errorsMap);
        }
        catch(Exception e)
        {
            displayExceptionMessage(e);
        }

        CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                   "CommandSuccessful",
                                                   new Object[] {name}));
    }


    private Map handleErrorDistribution(Map errorMap, Map resultMap, boolean isSevere) 
    {
        java.util.Set<String> keySet = errorMap.keySet();
        for (String module : keySet) {
            Integer count = (Integer) errorMap.get(module);
            if (count > 0)
            {
                if (isSevere)
                {
                    int[] errorCounts = new int[]{count,0};
                    resultMap.put(module, errorCounts);
                }
                else
                {
                    if (resultMap.containsKey(module))
                    {
                        int[] errorCounts = (int[])resultMap.get(module);
                        errorCounts[1] = count;
                        resultMap.put(module, errorCounts);
                    }
                    else
                    {
                        int[] errorCounts = new int[]{0, count};
                        resultMap.put(module, errorCounts);
                    }
                }
            }
        }
        return resultMap;
    }

    
    private void displayErrorDistribution(Map errorsMap)
    {
        if (errorsMap.size() > 0)
        {
            //display header
            String sTitle = String.format("%1$-9s %2$-14s %3$-40s",
                                          getLocalizedString("Severity"),
                                          getLocalizedString("Warning"),
                                          getLocalizedString("ModuleID"));
           
            CLILogger.getInstance().printDetailMessage(sTitle);
           
            CLILogger.getInstance().printDetailMessage("---------------------------------------------------------");
            
        }
        else
        {
            CLILogger.getInstance().printMessage(getLocalizedString("NoElementsToList"));
            return;
        }
        java.util.Set<String> keySet = errorsMap.keySet();
        for (String module : keySet) 
        {
            int[] errorCounts = (int[]) errorsMap.get(module);
            final String sErrorRecord = String.format("    %1$-8s %2$-8s %3$-40s",
                                                  errorCounts[0], errorCounts[1], module);
            CLILogger.getInstance().printMessage(sErrorRecord);
        }
    }
}
