/*
 * StartupReporter.java
 *
 * Created on March 7, 2006, 8:00 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.cli.commands;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.util.ArrayList;
import java.util.List;
import com.sun.enterprise.util.i18n.StringManager;
/**
 *
 * @author kedarm
 */
public class DomainReporter {
    
    private final boolean                   detailed;
    private final DomainConfig              dc;
    private static final CLILogger          logger = CLILogger.getInstance();
    private static final StringManager      lsm = StringManager.getManager(DomainReporter.class);
    private final List<String>              records = new ArrayList<String>();
    private ConfigContext                   cc = null; //the config context
    private String                          sn = null; // the server name
    /* package private constructor */
    DomainReporter(final DomainConfig dc, final boolean terse, 
        final ConfigContext cc) {
        if (dc == null || cc == null) {
            throw new IllegalArgumentException ("Null Argument");
        }
        this.dc       = dc;
        this.detailed = !terse;
        this.cc       = cc;
    }
    
    void report() throws ConfigException {
        prepare();
        display();
    }
    
    private void prepare() throws ConfigException {
        final PEFileLayout layout = new PEFileLayout(dc);
        final String xmlPath      = layout.getDomainConfigFile().getAbsolutePath();
        this.sn                   = SystemPropertyConstants.DEFAULT_SERVER_INSTANCE_NAME;
        
        final String ver = Version.getFullVersion();
        records.add(getDomainBanner(dc.getDomainName(), ver, dc.getDomainRoot()));
        if (detailed) {
            records.add(getAdminConsoleMessage());
            records.add(getHttpUrlsMessage());
            records.add(getWebContextsMessage());
            records.add(getJmxServiceUrlMessage());
            records.add(getOccupiedPorts());
            records.add(getClusterSupport());
            records.add(getDebugMessage());
        }
    }
    
    private String getDomainBanner(final String dn, final String version, final String dr) {
        return ( lsm.getString("domain.report.banner", dn, version, dr));
    }
    
    private String getDebugMessage() throws ConfigException {
        String msg = "";
        boolean debugMode = false;
        try{
            debugMode = (Boolean)dc.get(DomainConfig.K_DEBUG);
        } catch(final Exception e) {}//squelch
        if (debugMode) {
            final JavaConfig jc = ServerHelper.getConfigForServer(cc, sn).getJavaConfig();
            final String dopt = jc.getDebugOptions();
            msg = lsm.getString("start.debug.msg", dopt);
        }
        return ( msg );
    }
    private String getAdminConsoleMessage() throws ConfigException {
        final HttpListener admin = ServerHelper.getHttpListener(cc, sn, ServerHelper.ADMIN_HTTP_LISTNER_ID);
        String url = "", port = null;
        if (admin != null) {
            url = ServerHelper.getUrlString(admin);
            port = admin.getPort();
        }
        return ( lsm.getString("admin.console.msg", url, port) );
    }
    private String getHttpUrlsMessage() throws ConfigException {
        final HttpListener[] lss = ServerHelper.getHttpListeners(cc, sn);
        String urls = "";
        if (lss != null) {
            for (final HttpListener ls : lss) {
                if (ServerHelper.ADMIN_HTTP_LISTNER_ID.equals(ls.getId()))
                    continue;  //skip the admin listener
                if (ls.isEnabled()) {
                    urls += ServerHelper.getUrlString(ls);
                    urls += " ";
                }
            }
        }
        return ( lsm.getString("http.listeners.msg", urls) );
    }
    private String getWebContextsMessage() throws ConfigException {
        final WebModule[] wms = ServerHelper.getAssociatedWebModules(cc, sn);
        String crs = "";
        for (final WebModule wm : wms) {
           crs += wm.getContextRoot();
           crs += " ";
        }
        return ( lsm.getString("web.contexts.msg", crs) );
    }
    
    private String getJmxServiceUrlMessage() throws ConfigException {
        String url = "";
        final JmxConnector sjc = ServerHelper.getServerSystemConnector(cc, sn);
        if (sjc != null) {
            url += ServerHelper.getJmxServiceUrl(sjc);
        }
        return ( lsm.getString("jmx.connector.msg", url) );
    }
    private String getOccupiedPorts() throws ConfigException {
        String ports = "";
        ports = getHttpPorts() + getIiopPorts() + getJmxConnectorPorts();
        return ( lsm.getString("ports.msg", ports) );
    }
    private String getClusterSupport() throws ConfigException {
        final boolean sc = ServerHelper.isClusterAdminSupported(cc);
        if (sc)
            return (lsm.getString("clusters.supported.msg"));
        return (lsm.getString("clusters.not.supported.msg"));
    }
    private String getHttpPorts() throws ConfigException {
        String hp = "";
        final HttpListener[] hss = ServerHelper.getConfigForServer(cc, sn).getHttpService().getHttpListener();
        for (final HttpListener hs : hss) {
            if (hs.isEnabled()) {
                hp += hs.getPort();
                hp += " ";
            }
        }
        return ( hp );
    }
    private String getIiopPorts() throws ConfigException {
        String ip = "";
        final IiopListener[] ils = ServerHelper.getConfigForServer(cc, sn).getIiopService().getIiopListener();
        for (final IiopListener is : ils) {
            if (is.isEnabled()) {
                ip += is.getPort();
                ip += " ";
            }
        }
        return ( ip );
    }
    private String getJmxConnectorPorts() throws ConfigException {
        String jp = "";
        final JmxConnector[] jcs = ServerHelper.getConfigForServer(cc, sn).getAdminService().getJmxConnector();
        for (final JmxConnector jc : jcs) {
            if (jc.isEnabled()) {
                jp += jc.getPort();
                jp += " ";
            }
        }
        return ( jp );
    }
    
    private void display() {
        for (final String record : records) {
            logger.printMessage(record);
        }
    }
}
