/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 *  $Id: InstallAddonCommand.java,v 1.1 2006/11/08 17:03:23 binod Exp $
 */

package com.sun.enterprise.cli.commands;

import java.io.File;
import com.sun.enterprise.cli.framework.*;

/**
 * Install an Addon on top of appserver.
 */
public class InstallAddonCommand extends BaseLifeCycleCommand 
{


    /** Creates new DeleteDomainCommand */
    public InstallAddonCommand() 
    {
    }

    /**
     * Validates the Options for correctness
     * @return boolean returns true if validation is succesful else false
     */
    public boolean validateOptions() throws CommandValidationException 
    {
        return super.validateOptions();
    }
    
    /**
     * Executes the command
     * @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException 
    {
        validateOptions();
	
	String addonJar = null;
        try
        {            
	    addonJar = (String)operands.firstElement();
            File addonJarFile = new File(addonJar);
            if (addonJarFile.isFile() && addonJarFile.exists()) {
                AddonControl ac = new AddonControl();
                ac.install(addonJarFile);
            } else {
	        throw new CommandException
                (getLocalizedString("InvalidAddonFile", new Object[] {addonJar}));
            }
        }
        catch (CommandException ce)
        {
            throw ce;
        }
        catch (Throwable t)
        {
	    CLILogger.getInstance().printDetailMessage(t.getLocalizedMessage());
	    throw new CommandException(getLocalizedString("InstallAddonFailed",
							  new Object[] {addonJar}));
        }

	CLILogger.getInstance().printDetailMessage(getLocalizedString("InstallAddonCompleted",
                                             new Object[] {addonJar}));
    }

}
