/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ReflectionException;

import java.util.Vector;
import java.net.MalformedURLException;
import java.io.IOException;
import java.util.StringTokenizer;

/**
 *  This class is called for the show-comonent-status command.
 *  It uses the application mbean (object name: ias:type=applications,category=config)
 *  and the getStatus operation.  This information is defined in
 *  CLIDescriptor.xml,
 *  <p>
 *  The getStatus returns true if component is enabled else returns false.
 *  </p>
 *  @version  $Revision: 1.3 $
 */
public class ShowComponentStatusCommand extends S1ASCommand
{
    /**
     *  An abstract method that validates the options 
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of 
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException
    {
    	return super.validateOptions();
    }


    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        validateOptions();
        String objectName = getObjectName();
        Object[] params = getParamsInfo();
        String operationName = getOperationName();
        String[] types = getTypesInfo();

	//use http connector
	MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                     getUser(), getPassword());

        try
        { 
            final Object returnValue = mbsc.invoke(new ObjectName(objectName), 
					     operationName, params, types);
            displayComponentStatus(returnValue);
	    CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
						       new Object[] {name}));
        }
        catch(Exception e)
        { 
	    if (e.getLocalizedMessage() != null)
		CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(getLocalizedString("CommandUnSuccessful",
						     new Object[] {name} ), e);
        }        
    }


    /**
     *  display the status of the component.
     *  if the returnValue is true, then the component is enabled, else disabled.
     *  @throws CommandException is could not determine the status of the component.
     */
    private void displayComponentStatus(Object returnValue)
	throws CommandException
    {
	final String componentName = (String) getOperands().get(0);
	if (returnValue == null)
	    throw new CommandException(getLocalizedString("UndetermineStatus",
							  new Object[] {componentName}));
	else 
	{
	    //the return value must be Boolean
	    final String returnValClassName = returnValue.getClass().getName();
	    if (returnValClassName.equals(BOOLEAN_CLASS))
	    {
		final boolean status = ((Boolean)returnValue).booleanValue();
		if (status)
		    CLILogger.getInstance().printMessage(getLocalizedString(
			     "ComponentIsEnabled", new Object[] {componentName}));
		else
		    CLILogger.getInstance().printMessage(getLocalizedString(
			     "ComponentIsDisabled", new Object[] {componentName}));
	    }
	    else
		throw new CommandException(getLocalizedString("UndetermineStatus",
							      new Object[] {componentName}));
	}
    }

}
