/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.OS;
import java.io.File;

/**
 *  stop-database command
 *  This command class will invoke DerbyControl to stop
 *  the database.
 *  @author <a href="mailto:jane.young@sun.com">Jane Young</a>
 *  @version  $Revision: 1.10 $
 */
public final class StopDatabaseCommand extends DatabaseCommand
{
    private final static String DB_HOST       = "dbhost";
    private final static String DB_PORT       = "dbport";

    /**
     *  An  method that validates the options 
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of 
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException
    {
        return super.validateOptions();
    }


    /**
       defines the command to stop the derby database
       Note that when using Darwin (Mac), the property,
       "-Dderby.storage.fileSyncTransactionLog=True" is defined.
    */
    public String[] stopDatabaseCmd() throws Exception
    {
        if (OS.isDarwin()) {
            return new String [] {
                sJavaHome+File.separator+"bin"+File.separator+"java",
                "-Djava.library.path="+sInstallRoot+File.separator+"lib",
                "-Dderby.storage.fileSyncTransactionLog=True",
                "-cp",
                sClasspath + File.pathSeparator + sDatabaseClasspath,
                "com.sun.enterprise.cli.commands.DerbyControl",
                "shutdown",
                dbHost, dbPort, "false"
            };
        }
        return new String [] {
            sJavaHome+File.separator+"bin"+File.separator+"java",
            "-Djava.library.path="+sInstallRoot+File.separator+"lib",
            "-cp",
            sClasspath + File.pathSeparator + sDatabaseClasspath,
            "com.sun.enterprise.cli.commands.DerbyControl",
            "shutdown",
            dbHost, dbPort, "false"
       };
    }
    

    
    /**
     *  Method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        if (!validateOptions())
            throw new CommandValidationException("Validation is false");

        try {
            prepareProcessExecutor();
            CLIProcessExecutor cpe = new CLIProcessExecutor();
            cpe.execute(pingDatabaseCmd(false), true);
            if (cpe.exitValue() > 0) {
                    //if ping is unsuccesfull then database is not up and running
                throw new CommandException(getLocalizedString("StopDatabaseStatus", new Object[]{dbHost, dbPort}));
            }
            else if (cpe.exitValue() <0) {
                    // Something terribly wrong!
                throw new CommandException(getLocalizedString("CommandUnSuccessful",
                                                              new Object[] {name} ));
            }
            else {
                    //database is running so go ahead and stop the database
                cpe.execute(stopDatabaseCmd(), true);
                if (cpe.exitValue() > 0) {
                    throw new CommandException(getLocalizedString("CommandUnSuccessful",
                                                              new Object[] {name} ));
                }
                CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                           "CommandSuccessful",
                                                           new Object[] {name}));
            }
        }
        catch (Exception e) {
            displayExceptionMessage(e);
        }
    }
}
