/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.admin.pluggable.ClientPluggableFeatureFactory;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.common.Status;
import java.io.File;

/**
 *  This command class stops the domain
 *  @version  $Revision: 1.4.2.1 $
 */
public class StopDomainCommand extends BaseLifeCycleCommand {
    
    /**
     *  An abstract method that validates the options
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }
    
    public void stopDomain (String domainName) throws CommandException, CommandValidationException 
    {
        try {            
            final ClientPluggableFeatureFactory fac     = getFeatureFactory();
            final DomainsManager                mgr     = fac.getDomainsManager();
            final DomainConfig                  cfg     = getDomainConfig(domainName);
            final InstancesManager              im      = mgr.getInstancesManager(cfg);
            final int                           state   = im.getInstanceStatus();
            final String[]			domains = mgr.listDomains(cfg);
            boolean				exists	= false;
			
            for(int i = 0; domains != null && i < domains.length; i++)
     	    {
                if(domains[i].equals(domainName))
                {
                    exists = true;
                    break;
                }
            }

            if(!exists)
            {
                // it doesn't exist -- let the existing code throw an Exception with
		// the correct error message
                mgr.stopDomain(cfg);
            }

            // check if the Domain is running
            else if (state == Status.kInstanceRunningCode)
            {
                mgr.stopDomain(cfg);
            
                CLILogger.getInstance().printDetailMessage(getLocalizedString("DomainStopped",
                                                           new Object[] {domainName}));
            }
            else
            {
                //print the message if domain already stopped
                CLILogger.getInstance().printDetailMessage(getLocalizedString("CannotStopDomainAlreadyStopped",
                                                                              new Object[] {domainName}));
            }
            unconfigureAddons();
        }
        catch(Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());         
            throw new CommandException(getLocalizedString("CannotStopDomain",
                                                           new Object[] {domainName} ), e);
        }
    }
    
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException {
        validateOptions();
        String domainName = null;
        try {
            domainName = getDomainName();
        } catch(Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            domainName = domainName==null?getLocalizedString("Undefined"):domainName;
            throw new CommandException(getLocalizedString("CannotStopDomain",
                                                          new Object[] {domainName} ), e);
        }
        stopDomain(domainName);
    }

    private void unconfigureAddons() {
        try {
            AddonControl ac = new AddonControl();
            String domainInstanceRoot = getDomainsRoot() + File.separator + getDomainName();
            ac.unconfigureDAS(new File(domainInstanceRoot));
        }catch(Throwable t) {
            CLILogger.getInstance().printDetailMessage(t.getLocalizedMessage());
        }

    }

}
