/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Map;
import java.util.HashMap;
import java.util.Timer;
import java.io.File;

abstract class ConnectionPoolTask extends MonitorTask
{
    private final String displayFormat = "%1$-8s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s "+
                                         "%7$-5s %8$-5s %9$-5s %10$-5s %11$-5s %12$-5s %13$-5s "+
                                         "%14$-5s %15$-5s %16$-5s %17$-5s %18$-5s %19$-5s" ;
    
    public ConnectionPoolTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                              final boolean verbose, final File fileName)
    {
        super(srm, filter, timer, verbose, fileName);
    }

    
    void displayData(final ConnectionPoolStats cps)
    {
        final String data = String.format(displayFormat,
                                          cps.getAverageConnWaitTime().getCount(),
                                          cps.getConnRequestWaitTime().getLowWaterMark(),
                                          cps.getConnRequestWaitTime().getHighWaterMark(),
                                          cps.getConnRequestWaitTime().getCurrent(),
                                          cps.getNumConnAcquired().getCount(),
                                          cps.getNumConnCreated().getCount(),
                                          cps.getNumConnDestroyed().getCount(),
                                          cps.getNumConnFailedValidation().getCount(),
                                          cps.getNumConnFree().getLowWaterMark(),
                                          cps.getNumConnFree().getHighWaterMark(),
                                          cps.getNumConnFree().getCurrent(),
                                          cps.getNumConnNotSuccessfullyMatched().getCount(),
                                          cps.getNumConnReleased().getCount(),
                                          cps.getNumConnSuccessfullyMatched().getCount(),
                                          cps.getNumConnTimedOut().getCount(),
                                          cps.getNumConnUsed().getLowWaterMark(),
                                          cps.getNumConnUsed().getHighWaterMark(),
                                          cps.getNumConnUsed().getCurrent(),
                                          cps.getWaitQueueLength().getCount());
        System.out.println(data);
        if (fileName != null)
        {
            final String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s,%10$s,"+
                                              "%11$s,%12$s,%13$s,%14$s,%15$s,%16$s,%17$s,%18$s,%19$s",
                                              cps.getAverageConnWaitTime().getCount(),
                                              cps.getConnRequestWaitTime().getLowWaterMark(),
                                              cps.getConnRequestWaitTime().getHighWaterMark(),
                                              cps.getConnRequestWaitTime().getCurrent(),
                                              cps.getNumConnAcquired().getCount(),
                                              cps.getNumConnCreated().getCount(),
                                              cps.getNumConnDestroyed().getCount(),
                                              cps.getNumConnFailedValidation().getCount(),
                                              cps.getNumConnFree().getLowWaterMark(),
                                              cps.getNumConnFree().getHighWaterMark(),
                                              cps.getNumConnFree().getCurrent(),
                                              cps.getNumConnNotSuccessfullyMatched().getCount(),
                                              cps.getNumConnReleased().getCount(),
                                              cps.getNumConnSuccessfullyMatched().getCount(),
                                              cps.getNumConnTimedOut().getCount(),
                                              cps.getNumConnUsed().getLowWaterMark(),
                                              cps.getNumConnUsed().getHighWaterMark(),
                                              cps.getNumConnUsed().getCurrent(),
                                              cps.getWaitQueueLength().getCount());
            writeToFile(fileData);
        }
    }

    
    void displayHeader()
    {
        final String header = String.format("%1$s %2$12s %3$41s %4$40s",
                                            "WaitTime", "ConnReq", "ConnFree", "ConnUsed");
        final String subHeader = String.format(displayFormat,
                                               "avg","low","hi","cur","acq","crt",
                                               "des","fai","low","hi","cur","rej",
                                               "rel","suc","to","low","hi","cur","wai");
        System.out.println(header);
        System.out.println(subHeader);
        
        if (fileName != null) {
            writeToFile("AverageConnWaitTime,ConnRequestWaitTime:low,"+
                        "ConnRequestWaitTime:hi,ConnRequestWaitTime:current,"+
                        "NumConnAcquired,NumConnCreated,NumConnDestroyed,"+
                        "NumConnFailedValidation,NumConnFree:low,"+
                        "NumConnFree:hi,NumConnFree:current,NumConnRejected,"+
                        "NumConnReleased,NumConnSuccessfullyMatched,"+
                        "NumConnTimedOut,NumConnUsed:low,NumConnUsed:hi,"+
                        "NumConnUsed:current,NumConnServed");
        }
    }

    public void displayDetails()
    {
        System.out.println("***********************************************************");
        System.out.println("* avg  = Average wait time per successful connection (ms) *");
        System.out.println("* low  = Low water mark                                   *");
        System.out.println("* hi   = High water mark                                  *");
        System.out.println("* cur  = Current count                                    *");
        System.out.println("* acq  = Number of connections acquired                   *");
        System.out.println("* crt  = Number of connections created                    *");
        System.out.println("* des  = Number of connections destroyed                  *");
        System.out.println("* fai  = Number of connections failed                     *");
        System.out.println("* rej  = Number of connections rejected during matching   *");
        System.out.println("* rel  = Number of connections released back to the pool  *");
        System.out.println("* suc  = Number of connections successfully matched       *");
        System.out.println("* to   = Number of connections that timed out             *");
        System.out.println("* wai  = Number of connections waiting to be served       *");
        System.out.println("***********************************************************");        
    }

    
}
