/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.Map;
import java.util.HashMap;
import java.util.TimerTask;
import java.util.Timer;
import java.io.File;

public class ConnectorPoolMonitorTask extends ConnectionPoolTask
{
    public ConnectorPoolMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                                    final boolean verbose, final File fileName)
        throws MonitorTaskException
    {
        super(srm, filter, timer, verbose, fileName);
        final Map<String,ConnectorConnectionPoolMonitor> connectorMap = srm.getConnectorConnectionPoolMonitorMap();
        if (connectorMap == null)
            throw new MonitorTaskException("Unable to monitor connector connection pool.");
        final String[] keys = MapUtil.getKeyStrings(connectorMap);
        if (this.filter == null)
        {
            checkForNumberOfElements(keys);
            this.filter = keys[0];
        }
        else {
            if (!connectorMap.containsKey(this.filter)) {
                throw new MonitorTaskException(this.filter + " does not exist");
            }
        }
        
        final String title = String.format("%1$50s", "Connector Connection Pool Monitoring: "+this.filter);
        System.out.println(title);
        displayHeader();        
    }
    

    public void run()
    {
        if (srm == null) {
            super.cancelMonitorTask();
            return;
        }
        
        final Map<String,ConnectorConnectionPoolMonitor> connectorMap = srm.getConnectorConnectionPoolMonitorMap();
            //maybe lost connection?
        if (connectorMap == null || connectorMap.size()<1) {
            cancelMonitorTask();
            return;
        }
        
        if (verbose && counter == NUM_ROWS)
        {
            displayHeader();
            counter = 0;  //reset to 0
        }
        monitorConnectionPool(filter, connectorMap);
        if (verbose) counter++;
    }

    private void monitorConnectionPool(final String element,
                                       final Map<String,ConnectorConnectionPoolMonitor> connectorMap)
    {
        final ConnectorConnectionPoolMonitor connectorPoolMonitor = connectorMap.get(element);
        final ConnectorConnectionPoolStats stats = connectorPoolMonitor.getConnectorConnectionPoolStats();
        displayData(stats);
    }

}
