/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.Map;
import java.util.Timer;
import java.io.File;

public class HttpServiceVirtualServerMonitorTask extends MonitorTask
{
    private final String displayFormat = "%1$-20s %2$-10s %3$-20s %4$-10s";

    public HttpServiceVirtualServerMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                                               final boolean verbose, final File fileName)
        throws MonitorTaskException
    {
        super(srm, filter, timer, verbose, fileName);

        final HTTPServiceMonitor httpserviceMonitor = srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) 
            throw new MonitorTaskException("Unable to monitor virtualserver");
        final Map<String,HTTPServiceVirtualServerMonitor> httpServiceMap = httpserviceMonitor.getHTTPServiceVirtualServerMonitorMap();
        
        if (httpServiceMap == null)
            throw new MonitorTaskException("Unable to monitor virtualserver");
        
        final String[] keys = MapUtil.getKeyStrings(httpServiceMap);
        if (this.filter == null)
        {
            checkForNumberOfElements(keys);
            this.filter = keys[0];
        }
        else {
            if (!httpServiceMap.containsKey(this.filter)) {
                throw new MonitorTaskException(this.filter + " does not exist");
            }
        }
        final String title = String.format("%1$50s", "Virtual Server Monitoring " + this.filter);
        System.out.println(title);
        displayHeader();        
    }
    

    public void run()
    {
        if (srm == null) {
            super.cancelMonitorTask();
            return;
        }
        

        final HTTPServiceMonitor httpserviceMonitor = srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            cancelMonitorTask();
            return;
        }
        
        final Map<String,HTTPServiceVirtualServerMonitor> httpServiceMap = httpserviceMonitor.getHTTPServiceVirtualServerMonitorMap();
        if (httpServiceMap == null || httpServiceMap.size()<1) {
            cancelMonitorTask();
            return;
        }
        
        final HTTPServiceVirtualServerMonitor httpServiceMonitor = httpServiceMap.get(filter);
        if (httpServiceMonitor == null) {
            cancelMonitorTask();
            return;
        }
            
        final HTTPServiceVirtualServerStats httpServiceStats = httpServiceMonitor.getHTTPServiceVirtualServerStats();
        if (verbose && counter == NUM_ROWS)
        {
            displayHeader();
            counter = 0;  //reset to 0
        }
        displayData(httpServiceStats);
        if (verbose) counter++;
    }

    
    private void displayHeader()
    {
        final String header = String.format(displayFormat,
                                            "hosts","ID","intefaces","mode");
        System.out.println(header);
        if (fileName != null)
        {
            writeToFile("hosts,ID,interfaces,mode");
        }
    }

    
    private void displayData(final HTTPServiceVirtualServerStats vss)
    {
        final String data = String.format(displayFormat,
                                          vss.getHosts().getCurrent(),
                                          vss.getID().getCurrent(),
                                          vss.getInterfaces().getCurrent(),
                                          vss.getMode().getCurrent());
        System.out.println(data);
        if (fileName != null)
        {
            final String fileData = String.format("%1$s,%2$s,%3$s,%4$s,",
                                          vss.getHosts().getCurrent(),
                                          vss.getID().getCurrent(),
                                          vss.getInterfaces().getCurrent(),
                                          vss.getMode().getCurrent());
            writeToFile(fileData);
        }
    }

    
    public void displayDetails()
    {
        
        System.out.println("*********************************************************************************");
        System.out.println("* hosts      = The software virtual hostnames serviced by this Virtual Server   *");
        System.out.println("* ID         = Virtual Server ID                                                *");
        System.out.println("* interfaces = The interfaces for which this Virtual Server has been configured *");
        System.out.println("* mode       = Virtual Server mode                                              *");
        System.out.println("*********************************************************************************");
    }


}
    
    

