/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import javax.management.MBeanServerConnection;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.Timer;
import java.util.Map;
import java.util.HashMap;
import java.io.File;


public class JVMMonitorTask extends MonitorTask
{
    private final String displayFormat = "%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s";

    public JVMMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                          final boolean verbose, final File fileName)
    {
        super(srm, filter, timer, verbose, fileName);
        final String title = String.format("%1$45s", "JVM Monitoring");
        System.out.println(title);
        displayHeader();
    }
    

    public void run()
    {
        if (srm == null) {
            super.cancelMonitorTask();
            return;
        }
        
        final JVMStats jvmStats = srm.getJVMMonitor().getJVMStats();
        if (jvmStats == null) {
            cancelMonitorTask();
            return;
        }
        
        if (verbose && counter == NUM_ROWS)
        {
            displayHeader();
            counter = 0;  //reset to 0
        }
        displayData(jvmStats);
        if (verbose) counter++;
    }


    private void displayData(final JVMStats jvmStats)
    {
        final BoundedRangeStatistic heapSize = jvmStats.getHeapSize();
        final CountStatistic upTime = jvmStats.getUpTime();
        
        final String data = String.format(displayFormat,
                                          upTime.getCount(),
                                          heapSize.getLowerBound(),                                          
                                          heapSize.getUpperBound(),
                                          heapSize.getLowWaterMark(),
                                          heapSize.getHighWaterMark(),
                                          heapSize.getCurrent());
        System.out.println(data);
        if (fileName != null)
        {
            final String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s",
                                                  upTime.getCount(),
                                                  heapSize.getLowerBound(),                                          
                                                  heapSize.getUpperBound(),
                                                  heapSize.getLowWaterMark(),
                                                  heapSize.getHighWaterMark(),
                                                  heapSize.getCurrent());
            writeToFile(fileData);
        }
    }

    
    private void displayHeader()
    {
        final String header = String.format("%1$-45s %2$-20s",
                                            "UpTime(ms)",
                                            "HeapSize(bytes)");
        final String subHeader = String.format(displayFormat, "current", "min", "max", "low",
                                               "high", "count");
        System.out.println(header);
        System.out.println(subHeader);
        if (fileName != null) {
            writeToFile("UpTime(ms):current,HeapSize(bytes):min,HeapSize(bytes):max,"+
                        "HeapSize(bytes):low,HeapSize(bytes):high,HeapSize(bytes):count");
        }
    }

    public void displayDetails()
    {
        
    };
    
}
