/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.Map;
import java.util.HashMap;
import java.util.TimerTask;
import java.util.Timer;
import java.io.File;

public class KeepAliveMonitorTask extends MonitorTask
{
    private final String displayFormat = "%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s";

    public KeepAliveMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                                final boolean verbose, final File fileName)
        throws MonitorTaskException
    {
        super(srm, filter, timer, verbose, fileName);
        final String title = String.format("%1$40s", "Keep Alive Monitoring");
        System.out.println(title);
        displayHeader();        
    }
    

    public void run()
    {
        if (srm == null) {
            super.cancelMonitorTask();
            return;
        }
        

        final HTTPServiceMonitor httpserviceMonitor = srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            cancelMonitorTask();
            return;
        }
        

        final KeepAliveMonitor keepAliveMonitor = httpserviceMonitor.getKeepAliveMonitor();
        if (keepAliveMonitor == null) {
            cancelMonitorTask();
            return;
        }
        
        final KeepAliveStats keepAliveStats = keepAliveMonitor.getKeepAliveStats();

        if (verbose && counter == NUM_ROWS)
        {
            displayHeader();
            counter = 0;  //reset to 0
        }
        displayData(keepAliveStats);
        if (verbose) counter++;
    }

    
    private void displayHeader()
    {
        final String header = String.format(displayFormat,
                                            "cc","cf","ch","cr","cto","mc","sto");
        System.out.println(header);
        if (fileName != null)
        {
            writeToFile("CountConnections,CountFlushes,CountHits,CountRefusals,CountTimeouts,"+
                        "MaxConnections,SecondsTimeouts");
        }
    }

    
    private void displayData(final KeepAliveStats kas)
    {
        final String data = String.format(displayFormat,
                                          kas.getCountConnections().getCount(),
                                          kas.getCountFlushes().getCount(),
                                          kas.getCountHits().getCount(),
                                          kas.getCountRefusals().getCount(),
                                          kas.getCountTimeouts().getCount(),
                                          kas.getMaxConnections().getCount(),
                                          kas.getSecondsTimeouts().getCount());
        System.out.println(data);
        if (fileName != null)
        {
            final String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s",
                                                  kas.getCountConnections().getCount(),
                                                  kas.getCountFlushes().getCount(),
                                                  kas.getCountHits().getCount(),
                                                  kas.getCountRefusals().getCount(),
                                                  kas.getCountTimeouts().getCount(),
                                                  kas.getMaxConnections().getCount(),
                                                  kas.getSecondsTimeouts().getCount());
            writeToFile(fileData);
        }
    }

    
    public void displayDetails()
    {
        
        System.out.println("*********************************************************************");
        System.out.println("* cc  = Number of connections in keep-alive mode                    *");
        System.out.println("* cf  = Number of keep-alive connections that were closed           *");
        System.out.println("* ch  = Number of cache lookup hits                                 *");
        System.out.println("* cr  = Number of keep-alive connections that were rejected         *");
        System.out.println("* cto = Number of keep-alive connections that timed out             *");
        System.out.println("* mc  = Maximum number of concurrent connections in keep-alive mode *");
        System.out.println("* sto = Keep-alive timeout in number of seconds                     *");
        System.out.println("*********************************************************************");        
    }


}
    
    

