/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.appserv.management.util.misc.MapUtil;
import java.util.StringTokenizer;
import java.util.Map;
import java.util.Timer;
import java.util.List;
import java.util.Vector;
import java.io.File;

public class MessageDrivenBeanMonitorTask extends BeanMonitorTask
{
    private final String displayFormat = "%1$-10s %2$-10s %3$-10s";

    public MessageDrivenBeanMonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                                        final boolean verbose, final File fileName)
        throws MonitorTaskException
    {
        super(srm, filter, timer, verbose, fileName);
        
        if (this.filter == null)
            getDefaultFilter();
        else
        {
            final StringTokenizer st = new StringTokenizer(this.filter, ":");
            if (st.countTokens() < 2 )
                throw new MonitorTaskException("Invalid filter format.  EntityBeans are in either ejbmodule "+
                                               "or appmodule.  Please use the format: <ejbmodule>:<messagedrivenbean> " +
                                               "or <appmodule>:<ejbmodule>:<messagedrivenbean>.");
            else if (st.countTokens() == 2)
            {
                ejbName = st.nextToken();
                beanName = st.nextToken();
            }
            else {
                appName = st.nextToken();
                ejbName = st.nextToken();
                beanName = st.nextToken();
            }
            verifyFilterValue();
        }
        final String title = String.format("%1$50s", "Message Driven Bean Monitoring " + this.filter);
        System.out.println(title);
        displayHeader();        
    }
    

    public void run()
    {
        if (srm == null) {
            super.cancelMonitorTask();
            return;
        }
        
        Map<String,EJBModuleMonitor> ejbMap = null;
        if (appName == null)
        {
            ejbMap = srm.getEJBModuleMonitorMap();
        }
        else
        {
            final Map<String,ApplicationMonitor> appMap = srm.getApplicationMonitorMap();
            if (appMap == null || appMap.size()<1) {
                cancelMonitorTask();
                return;
            }
            final ApplicationMonitor am = appMap.get(appName);
            ejbMap = am.getEJBModuleMonitorMap();
        }
        if (ejbMap == null || ejbMap.size()<1) {
            cancelMonitorTask();
            return;
        }
        
        final MessageDrivenBeanMonitor monitor = getMessageDrivenBeanMonitor(ejbMap);
        if (monitor == null) {
            cancelMonitorTask();
            return;
        }
        
            
        final MessageDrivenBeanStats stat = monitor.getMessageDrivenBeanStats();
        if (verbose && counter == NUM_ROWS)
        {
            displayHeader();
            counter = 0;  //reset to 0
        }
        displayData(stat);
        if (verbose) counter++;
    }

    
    private MessageDrivenBeanMonitor getMessageDrivenBeanMonitor(final Map<String,EJBModuleMonitor> ejbMap)
    {
        final EJBModuleMonitor ejbModuleMonitor = ejbMap.get(ejbName);
        final Map<String,MessageDrivenBeanMonitor> mdbMap = ejbModuleMonitor.getMessageDrivenBeanMonitorMap();
        return mdbMap.get(beanName);
    }
    
    
    List<String> getBeansInEjbModule(final String appName,
                                     final Map<String,EJBModuleMonitor> ejbModuleMap)
    {
        List<String> possibleMessageDrivenBeans = new Vector<String>();
        final String[] ejbModules = MapUtil.getKeyStrings(ejbModuleMap);
        if (ejbModuleMap != null && ejbModuleMap.size() > 0)
        {
            for (String ejbModule : ejbModules)
            {
                final EJBModuleMonitor ejbModuleMonitor = ejbModuleMap.get(ejbModule);
                final Map<String,MessageDrivenBeanMonitor> messageBeanMap = ejbModuleMonitor.getMessageDrivenBeanMonitorMap();
                final String[] messageDrivenBeans = MapUtil.getKeyStrings(messageBeanMap);
                for (String messageDrivenBean : messageDrivenBeans)
                {
                    if (appName == null)
                        possibleMessageDrivenBeans.add(ejbModule+":"+messageDrivenBean);
                    else
                        possibleMessageDrivenBeans.add(appName+":"+ejbModule+":"+messageDrivenBean);
                }
            }
        }
        return possibleMessageDrivenBeans;
    }

    
        /**
         * returns true if entitybean exists in ejbmodule
         * @throws MonitorTaskException if ejbmodule is invalid.
         */
    boolean checkIfBeanExists(final Map<String,EJBModuleMonitor> ejbModuleMap)
        throws MonitorTaskException
    {
        if (!ejbModuleMap.containsKey(ejbName))
        {
            if (appName == null)
                throw new MonitorTaskException(ejbName + " does not exist.");
            else
                throw new MonitorTaskException(ejbName + " does not exist in " + appName+ ".");                
        }
        else {
            final EJBModuleMonitor ejbModuleMonitor = ejbModuleMap.get(ejbName);
            final Map<String,MessageDrivenBeanMonitor> messageBeanMap = ejbModuleMonitor.getMessageDrivenBeanMonitorMap();
            if (!messageBeanMap.containsKey(beanName))
                return false;
            else
                return true;
        }
    }
    
    
    private void displayHeader()
    {
        final String header = String.format(displayFormat, "Message","Create","Remove");
        
        System.out.println(header);
        if (fileName != null)
        {
            writeToFile("MessageCount,CreateCount,RemoveCount");
        }
    }

    
    private void displayData(final MessageDrivenBeanStats stat)
    {
        final String data = String.format(displayFormat,
                                          stat.getMessageCount().getCount(),
                                          stat.getCreateCount().getCount(),
                                          stat.getRemoveCount().getCount());
        System.out.println(data);
        if (fileName != null)
        {
            final String fileData = String.format("%1$s,%2$s,%3$s",
                                          stat.getMessageCount().getCount(),
                                          stat.getCreateCount().getCount(),
                                          stat.getRemoveCount().getCount());
            writeToFile(fileData);
        }
    }

    
    public void displayDetails()
    {
        System.out.println("*******************************************************");
        System.out.println("* message = Number of messages received.              *");
        System.out.println("* create  = Number of times create method was called. *");
        System.out.println("* remove  = Number of times remove method was called. *");
        System.out.println("*******************************************************");
    }


}
    
    

