/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands.monitor;

import com.sun.enterprise.cli.framework.*;
import com.sun.appserv.management.monitor.*;
import com.sun.appserv.management.monitor.statistics.*;
import javax.management.j2ee.statistics.*;
import com.sun.appserv.management.j2ee.statistics.*;
import java.util.TimerTask;
import java.util.Timer;
import java.io.File;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;


public abstract class MonitorTask extends TimerTask
{
    final int NUM_ROWS = 25;
    int counter = 0;
    ServerRootMonitor srm = null;
    String monitorType = null;
    String filter = null;
    Timer timer = null;
    File fileName = null;
    boolean verbose = false;

    public MonitorTask() {}


    abstract public void displayDetails();
    
    public MonitorTask(final ServerRootMonitor srm, final String filter, final Timer timer,
                       final boolean verbose, final File fileName)
    {
        this.srm = srm;
        this.timer = timer;
        if (filter != null)
            this.filter = filter;
        this.verbose = verbose;
        this.fileName = fileName;
    }

    void cancelMonitorTask()
    {
        timer.cancel();
        System.out.println("Press 'q' or 'Q' to quit. ");
    }

    void checkForNumberOfElements(String[] keys) throws MonitorTaskException
    {
        if (keys.length<1)
        {
            throw new MonitorTaskException("No value to monitor.");
        }
        else if (keys.length > 1)
        {
            StringBuffer sb = new StringBuffer();
            sb.append("There are more than one monitoring elements. ");
            sb.append("Please consider using the filter option.\n");
            sb.append("The following are available elements to monitor: \n");
            for (String key: keys) {
                sb.append("    ");
                sb.append(key);
                sb.append("\n");
            }
            throw new MonitorTaskException(sb.toString());
        }
    }

    
    synchronized void writeToFile(final String text)
    {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName, true));
            out.append(text);
            out.newLine();
            out.close();
        }
        catch (IOException ioe) {
            System.out.println("Unable to write to file, "+fileName.getName());
            if (verbose)
                ioe.printStackTrace();
        }
    }
}
