/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.cli.commands;

/**
   Note that this test requires resources for testing. These resources
   are construct4ed from the two files P1 & P2 located in the current
   directory. If these file names are changed then the corresponding
   names in this submodules build.xml file should be changed also
*/
import com.sun.enterprise.cli.framework.*;
//import java.util.ArrayList;
//import java.util.Arrays;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Properties;
import junit.framework.*;
import junit.textui.TestRunner;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.File;
/**
 *
 * @author prashanth.abbagani@sun.com
 * @version $Revision: 1.3 $
 */

/**
   Execute these tests using gmake (and Ant) by:
   cd <commands>
   gmake ANT_TARGETS=CommandTest.java
*/

public class BackupCommandsTest extends TestCase {

    public void testValidateOptionsInvalidCommandName() throws Exception{
        try{
            testCommand.validateOptions();
        }
        catch (CommandValidationException cve){
            assertEquals(cve.getMessage(), 
            "There is no such command sampleCommand.  Use \"asadmin help\" for a list of valid commands.");
        }
    }
/*
    public void testValidateOptionsInvalidVerboseAndTerse() throws Exception{
        try{
            testCommand.setName("backup-domain");
            testCommand.setOption("terse", "true");
            testCommand.setOption("verbose", "true");
            testCommand.validateOptions();
        }
        catch (CommandValidationException cve){
            assertEquals(cve.getMessage(), 
            "The verbose and terse options can''t both be true at the same time.");
        }
    }
*/

    //check the error from isRunning()
    public void testValidateOptionsInvalidDomainPath() throws Exception{
        try{
            testCommand.setName("backup-domain");
            testCommand.setOption("domaindir", "InvalidDomainDir");
            testCommand.validateOptions();
        }
        catch (CommandValidationException cve){
            assertEquals(cve.getMessage(), 
            "com.sun.enterprise.cli.framework.CommandException: Domain directory "+
            new File("InvalidDomainDir").getAbsolutePath() +" is not a directory or does not exist.");
        }
    }

    public BackupCommandsTest(String name){
        super(name);
    }

    BackupCommands testCommand = null;

    protected void setUp() throws Exception{
        //Properties systemProperties = new java.util.Propertis();
        //systemProperties.put("com.sun.aas.configRoot",)
        //String configProperty = SystemPropertyConstants.CONFIG_ROOT_PROPERTY;
        //System.out.println(configProperty + " = " + System.getProperty(configProperty));
        final CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
        ValidCommand validCommand = cliDescriptorsReader.getCommand(null);
        LocalStringsManagerFactory.setCommandLocalStringsManagerProperties(
            CLIDescriptorsReader.getInstance().getProperties());
        testCommand = new BackupCommands();
        testCommand.setName("sampleCommand");
    }
  
  

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static Test suite(){
        TestSuite suite = new TestSuite(BackupCommandsTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(BackupCommandsTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
}

