/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.PrintStream;
import java.io.OutputStream;


/**
	non-public helper classes
 */
class NullOutput implements IOutput
{
	NullOutput( )
	{
	}

	public void print( String msg )
	{
		// do nothing
	}

	public void print( Object msg )
	{
		// do nothing
	}

	public void println( String msg )
	{
		// do nothing
	}

	public void println( Object msg )
	{
		// do nothing
	}

	public void close()
	{
		// do nothing
	}

	public void flush()
	{
		// do nothing
	}
}


class Output implements IOutput
{
    OutputStream mOutputStream  = null;
    PrintStream  mPrint         = null;
    boolean      mCloseWhenDone = false;

    public Output( OutputStream outputStream, boolean closeWhenDone )
		   throws Exception
    {
	mPrint  = new PrintStream( outputStream );

	// don't assign these unless we were successful creating mPrintWriter
	mOutputStream   = outputStream;
	mCloseWhenDone  = closeWhenDone;
    }

    /**
	Call to release/close the output stream when done.
	This prevents files from remaining open for a long time.
    */
    public void close()
    {
	if ( mCloseWhenDone )
	{
	    try
	    {
		mOutputStream.close();
	    }
	    catch( Exception e )
	    {
	    }
	}
	mOutputStream   = null;
	mPrint          = null;
	mCloseWhenDone  = false;
    }


    public void print( String msg )
    {
	mPrint.print( msg );
    }


    public void print( Object msg )
    {
	mPrint.println( msg.toString() );
    }


    public void println( String msg )
    {
	mPrint.println( msg );
    }


    public void println( Object msg )
    {
	mPrint.println( msg.toString() );
    }


    public void flush()
    {
        try
	{
	    mOutputStream.flush();
	}
	catch( Exception e )
	{
	}
    }
}


/**
	A base class for all different types of outputs.
 */
public abstract class GenericOutput implements IOutput
{
	private IOutput mOutput = null;


	/**
		A generic constructor with an OutputStream object and a boolean.

		@param out              is the OutputStream object to be set.
		@param closeWhenDone    is the boolen tag.
	 */
	protected GenericOutput( OutputStream out, boolean closeWhenDone )
	{
		try
		{
			if ( out != null )
			{
				mOutput = new Output( out, closeWhenDone );
			}
			else
			{
				mOutput = new NullOutput();
			}

		}
		catch ( Exception e )
		{
			mOutput = new NullOutput();
		}
	}


	/**
		Print a string.

		@param s - The String to be printed
	 */
	public void print( String message )
	{
		mOutput.print( message );
	}


	/**
		Print a string.

		@param msg - object on which toString() will be called.
	 */
	public void print( Object msg )
	{
		mOutput.print( msg.toString() );
	}


	/**
		Print a String and then terminate the line.

		@param s - The String to be printed
	 */
	public void println( String message )
	{
		mOutput.println( message );
	}


	/**
		Print a String and then terminate the line.

		@param msg - object on which toString() will be called.
	 */
	public void println( Object msg )
	{
		mOutput.println( msg.toString() );
	}


	/**
		Closes the underlying output stream.
	 */
	public void	close()
	{
		mOutput.close();
		mOutput = new NullOutput();
	}


	/**
		Flushes this output stream and forces any buffered output bytes to
		be written out.
	 */
	public void	flush()
	{
		mOutput.flush();
	}


}
