/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LocalStringsManagerFactory.java
 *
 * Created on July 29, 2003, 4:48 PM
 */

package com.sun.enterprise.cli.framework;

//imports
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.Properties;

/**
 *
 *  This is a factory class that creates the LocalStringsManager
 * @author  pa100654
 */
public class LocalStringsManagerFactory {
    
    private static HashMap stringManagers = new HashMap();
    private static String PROPERTY_FILE = "LocalStrings";
    private final static String FRAMEWORK_BASE_PACKAGE = LocalStringsManagerFactory.class.getPackage().getName();
    private static LocalStringsManager commandLocalStringsManager = null;
    
    /** Creates a new instance of LocalStringsManagerFactory */
    protected LocalStringsManagerFactory() 
    {
    }
    
    /**
        Sets the LocalStringsManager object.
        @param packageName name of the package used by the LocalStringsManager.
        @param stringsManager LocalStringsManager object
    */
    public static void setInstance(String packageName, 
                                    LocalStringsManager stringsManager)
    {
        stringManagers.put(packageName, stringsManager);
    }

    /**
        Returns the instance of the LocalStringsManager object,
        the caller can access all the methods in this class.
        @param packageName name of the package
    */
    public static LocalStringsManager getLocalStringsManager(
                                            String packageName, 
                                            String propertiesFileName)
            throws CommandValidationException
    {
        LocalStringsManager stringsManager = 
                    (LocalStringsManager) stringManagers.get(packageName);
        if ((stringsManager == null) || 
            (!stringsManager.getPropertiesFile().equals(propertiesFileName)))
        {
            try
            {
                stringsManager = new LocalStringsManager(packageName, 
                                                            propertiesFileName);
                stringManagers.put(packageName, stringsManager);
            }
            catch(java.util.MissingResourceException mre)
            {
                //throw new CommandException(mre.getLocalizedMessage());
                throw new CommandValidationException(mre.getLocalizedMessage(), mre);
            }
        }
        return stringsManager;
    }


    /**
     *  Returns the instance of the LocalStringsManager object for 
     *	the CLI framework module.
     *  the caller can access all the methods in this class.
     *   @param packageName name of the package
     */
    public static LocalStringsManager getFrameworkLocalStringsManager()
            throws CommandValidationException
    {
        return getLocalStringsManager(FRAMEWORK_BASE_PACKAGE, PROPERTY_FILE);
    }

    /**
     *  sets the list of base_package and property_file_name properties for 
     *	the CLI Commands module.
     *   @param properties vector of java.util.Properties (name/value pairs of 
                            base-package and property-file-name) objects
     */
    public static void setCommandLocalStringsManagerProperties(
                                                Iterator propertiesIter)
            throws CommandValidationException
    {
        Vector localizePropertiesList = new Vector();
        while (propertiesIter.hasNext())
        {
		    Properties localizeProperties = new Properties();
            Properties properties = (Properties) propertiesIter.next();
            String basePackage = properties.getProperty("base-package");
            String propertyFile = properties.getProperty("property-file-name",
                                    LocalStringsManagerFactory.PROPERTY_FILE);
            if ((basePackage != null) && (!basePackage.equals("")))
            {
		CLILogger.getInstance().printDebugMessage("basePackage: " + basePackage);
		CLILogger.getInstance().printDebugMessage("propertyFile: " + propertyFile);
                localizeProperties.setProperty("base-package", basePackage);
                localizeProperties.setProperty("property-file-name", propertyFile);
                localizePropertiesList.add(localizeProperties);
            }
        }
        if (localizePropertiesList.size() > 0)
        {
            commandLocalStringsManager = 
                               new LocalStringsManager(localizePropertiesList);
        }
    }

    /**
     *  Returns the instance of the LocalStringsManager object for 
     *	the CLI Commands module.
     *  the caller can access all the methods in this class.
     */
    public static LocalStringsManager getCommandLocalStringsManager()
            throws CommandValidationException
    {
        if (commandLocalStringsManager == null)
        {
            LocalStringsManager lsm = 
                LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(
                        lsm.getString("CouldNotFindLocalStringsProperties"));
        }
        return commandLocalStringsManager;
    }

}
