/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.util.Iterator;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;

/**
 *    SearchCommands.java
 *    This class cannot be instantiated.
 *    Given a pattern, this class will search for
 *    the commands that match the pattern.
 *    @version  $Revision: 1.2 $
 */
public class SearchCommands
{
    private Map<String, String> allCommandsMap = null;

    
        //private constructor cannot be instantiated
    private SearchCommands() throws CommandValidationException
    {
        final CLIDescriptorsReader cdr = CLIDescriptorsReader.getInstance();
        final ValidCommandsList vcl = cdr.getCommandsList();
        final Iterator<ValidCommand> commands = vcl.getCommands();
        allCommandsMap = new Hashtable<String, String>();
        while (commands.hasNext())
        {
            final ValidCommand command = (ValidCommand)commands.next();
            //System.out.println("command = " + command.getName());
            final String  usageText = command.getUsageText();

            //Do not want to include the hiddden commands
            //the hidden commands have empty usageText
            if (usageText != null && usageText.length()>0)
                allCommandsMap.put(command.getName(), command.getUsageText());
        }
    }

        /**
         *  returns all the valid commands
         **/
    public static String[] getAllCommands()
        throws CommandValidationException
    {
        return new SearchCommands().allCommands();
    }

        /**
         *  returns commands that matches the pattern
         **/
    public static String[] getMatchedCommands(String pattern)
        throws CommandException, CommandValidationException
    {
        return new SearchCommands().findCommands(pattern);
    }

    private String[] allCommands()
    {
        final Set<String> set = allCommandsMap.keySet();
        return (String[])set.toArray(new String[set.size()]);
    }
            

    private String[] findCommands(final String pattern)
        throws CommandException
    {
        try 
        {
            List<String> allCommandsList = new Vector<String>(allCommandsMap.keySet());
                //sort commands in alphabetical order
            Collections.sort(allCommandsList);

            List<String> matchedCommands = new Vector();
            for (int ii=0; ii+1<allCommandsList.size();ii++)
            {
//                System.out.println("Matching pattern : " + allCommandsList.get(ii) + "  " + pattern);
                if (allCommandsList.get(ii).matches(pattern)) {
                    matchedCommands.add(allCommandsList.get(ii));
                }
            }
            return (String[])matchedCommands.toArray(new String[matchedCommands.size()]);
        }
        catch (PatternSyntaxException pse)
        {
            throw new CommandException("InvalidPattern", pse);
        }
        catch (Exception e){
            throw new CommandException(e);
        }
    }
}
    
    

