/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.StringReader;
import java.io.Writer;
import junit.framework.*;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class PagerTest extends TestCase {
  public void testNegativeLinesPerPage() throws IOException {
        final Pager m = new Pager(-1, new StringReader("1\n2\n3"),
                                stdout.getWriter());
		m.nextPage();
		assertEquals("1", stdout.readLine());
		assertEquals("2", stdout.readLine());
		assertEquals("3", stdout.readLine());
		assertTrue("Output should no longer be ready", !stdout.ready());
  }
  
    public void testHasNext() throws IOException {
        final Pager m = new Pager(2, new StringReader("1\n2\n3"),
                                stdout.getWriter());
        assertTrue("Didn't expect anything in the output!",
                   !stdout.ready());
        m.nextPage();
        assertTrue(m.hasNext());
        m.nextPage();
        assertTrue(!m.hasNext());
    }
    

    public void testZeroLengthPage() throws IOException {
        final Pager m = new Pager(0, new StringReader("1\n2\n3\n4\n5\n6\n7"),
                                stdout.getWriter());
        assertTrue("Didn't expect anything in the output!",
                   !stdout.ready());
        m.nextPage();
        assertTrue("Didn't expect anything in the output!",
                   !stdout.ready());
    }
    

        
        
    public void testMultiplePages() throws IOException {
        final Pager m = new Pager(2, new StringReader("1\n2\n3\n4\n5\n6\n7"), stdout.getWriter());
        assertTrue("Didn't expect anything in the output!", !stdout.ready());
        m.nextPage();
        assertTrue("Expected something on the output!", stdout.ready());
        assertEquals("1", stdout.readLine());
        assertEquals("2", stdout.readLine());
        assertTrue("Expected end of page 1", !stdout.ready());
        m.nextPage();
        assertTrue("Expected page 2 to be ready", stdout.ready());
        assertEquals("3", stdout.readLine());
        assertEquals("4", stdout.readLine());
        assertTrue("Expected to be waiting for page 3", !stdout.ready());
        m.nextPage();
        assertEquals("5", stdout.readLine());
        assertEquals("6", stdout.readLine());
        assertTrue("Expected to be waiting for page 4", !stdout.ready());
        m.nextPage();
        assertEquals("7", stdout.readLine());
        assertTrue("Expected end of page 4", !stdout.ready());
    }
        
    public void testSinglePage() throws IOException {
        final Pager m = new Pager(2, new StringReader("1\n2\n"), stdout.getWriter());
        assertTrue("Didn't expect anything in the output!", !stdout.ready());
        m.nextPage();
        assertTrue("Expected something on the output!", stdout.ready());
        assertEquals("1", stdout.readLine());
        assertEquals("2", stdout.readLine());
        assertTrue("Expected no more output", !stdout.ready());
    }


    public PagerTest(String name){
        super(name);
    }
    Pipe stdout;
    protected void setUp() throws IOException {
        stdout = new Pipe();
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(PagerTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new PagerTest(args[i]));
        }
        return ts;
    }

    class Pipe
    {
        PipedWriter pw = new PipedWriter();
        PipedReader pr = new PipedReader();
        BufferedReader br = new BufferedReader(pr);
        Writer getWriter(){ return pw; }
        BufferedReader getReader() { return br; }

        Pipe() throws IOException { pr.connect(pw); }
        String readLine() throws IOException {
            return br.readLine();
        }
        boolean ready() throws IOException {
            return br.ready();
        }

        
    }
        
        

}
