/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.interceptor;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InvalidAttributeValueException;
import javax.management.InstanceNotFoundException;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.InstanceNotFoundException;

/**
    Allows registration of MBeans dynamically for a restricted set of MBeanServer methods.
    These include:<br/>
    <ul>
    <li>isRegistered</li>
    <li>getClassLoaderFor</li>
    </ul>
    Other methods such as get/setAttribute(s) and invoke() are not supported.
 */
public interface DynamicInterceptorRegistrationHook
{
    /**
        Called when an MBean is not registered.  If desired, the MBean may be registered.
        Note that nothing precludes another thread from registering the specified MBean at any time,
        and thus registrationHook() could be called with the MBean already registered.
        @param MBeanServer  the MBeanServer in which the missing MBean should be registered
        @param ObjectName   the ObjectName of the non-registered MBean
        @return true if the MBean is now presnt.
     */
    public boolean   registrationHook( final MBeanServer server, final ObjectName objectName );
};








