/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.interceptor;

import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerBuilder;


/*
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;
import java.util.logging.Level;
*/

/**
 */
public final class InterceptorMBeanServerBuilder extends javax.management.MBeanServerBuilder
{
    //protected final Logger _logger = Logger.getLogger(AdminConstants.kLoggerName);

    public InterceptorMBeanServerBuilder()
    {
    }

        public synchronized MBeanServer
    newMBeanServer(
        final String defaultDomain, 
        final MBeanServer outer, 
        final MBeanServerDelegate delegate)
    {
        if ( outer != null )
        {
            throw new Error( "InterceptorMBeanServerBuilder: outer not supported" );
        }
        
        final DynamicInterceptor dynamicInterceptor = new DynamicInterceptor();
        final MBeanServer realMBeanServer = super.newMBeanServer( defaultDomain, dynamicInterceptor, delegate);
        dynamicInterceptor.setDelegateMBeanServer( realMBeanServer );
        return dynamicInterceptor;
    }
    
        public MBeanServerDelegate
    newMBeanServerDelegate() 
    {
        return super.newMBeanServerDelegate();
    }
}